﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.ManuHostTools.UsbLibrary;

namespace UsbLoopBack
{
    class Program
    {
        // USB デバイスの GUID
        private static readonly Guid UsbDeviceGuid = new Guid("97FFFD48-2D1D-47A0-85A3-07FDE6FA0143");

        // 乱数データのサイズ
        private static readonly int RandomDataSize = 2048;

        static void Main(string[] args)
        {
            // USB デバイスの検出
            var deviceList = UsbDevice.WaitForDetectUsbDeviceByGuid(UsbDeviceGuid, TimeSpan.FromSeconds(1));
            if(deviceList.Count == 0)
            {
                Console.WriteLine("Device not found");
                return;
            }

            // 検出された一つのデバイスと接続を確立
            var usbSession = new UsbSession();
            usbSession.CreateSession(deviceList[0], 2);

            // データの送受信を100回繰り返す
            for (int i = 0; i < 100; i++)
            {
                // 乱数データの生成
                var writeBuf = new byte[RandomDataSize];
                var r = new Random();
                r.NextBytes(writeBuf);

                // 乱数データの送信
                usbSession.Write(writeBuf, 0, writeBuf.Length);

                // データを受信
                var readBuf = new byte[RandomDataSize];
                usbSession.Read(readBuf, 0, readBuf.Length);

                // 送信したデータと受信したデータが一致することを確認
                bool isEqual = writeBuf.SequenceEqual(readBuf);
                if (!isEqual)
                {
                    Console.WriteLine("write read not equal");
                    return;
                }
            }
        }
    }
}
