﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Diagnostics;

namespace MultipleRunFinalize
{
    partial class Program
    {
        public static void KillProcessByName(string processName)
        {
            var processes = System.Diagnostics.Process.GetProcessesByName(processName);
            foreach(var process in processes)
            {
                process.Kill();
                process.Close();
                process.Dispose();
            }
        }

        public static void TestEnsureExistFile(string path)
        {
            if (!File.Exists(path))
            {
                throw new FileNotFoundException($"ファイルが見つかりません。 {path}");
            }
        }

        public static void TestEnsureExistDirectory(string path)
        {
            if (!Directory.Exists(path))
            {
                throw new DirectoryNotFoundException($"ディレクトリが見つかりません。 {path}");
            }
        }

        public static void CreateDirectoryIfNotExist(string directory)
        {
            if (!Directory.Exists(directory))
            {
                Directory.CreateDirectory(directory);
            }
        }

        public static Process InvokeCommand(string exe, string args, bool isRedirect = false)
        {
            TestEnsureExistFile(exe);

            var process = new Process();
            var info = new ProcessStartInfo();

            info.FileName = exe;
            info.Arguments = args;
            info.RedirectStandardOutput = isRedirect;
            info.RedirectStandardError = isRedirect;
            info.UseShellExecute = !isRedirect;
            info.CreateNoWindow = false;
            info.WindowStyle = ProcessWindowStyle.Hidden;

            process.StartInfo = info;
            process.Start();
            process.WaitForExit();

            return process;
        }

        public static Process InvokePowerShell(string script,string args, string logFile="")
        {
            TestEnsureExistFile(script);

            var cmd = @"C:\Windows\System32\cmd.exe";
            if (String.IsNullOrEmpty(logFile))
            {
                return InvokeCommand(cmd, $"/C powershell -Version 2.0 -InputFormat None -ExecutionPolicy RemoteSigned {script} {args}");
            }
            else
            {
                return InvokeCommand(cmd, $"/C powershell -Version 2.0 -InputFormat None -ExecutionPolicy RemoteSigned {script} {args} 2>&1 | {option.LoggerPath} \"{logFile}\"");
            }
        }

        public static string GetDevicePathOption(string devicePath)
        {
            return String.IsNullOrEmpty(devicePath) ? String.Empty : $"--usb_device_path \"{devicePath}\"";
        }
    }
}
