﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;
using System.Reflection;

namespace Nintendo.ManuHostTools
{
    internal class ProgramOption
    {
        public Guid UsbGuid { get; private set; }
        public bool IsVerbose = false;

        private static readonly Dictionary<string, Guid> UsbGuidList = new Dictionary<string, Guid>()
          {
            {"frcm", new Guid("EAD8C4F6-6102-45C7-AA66-36E6D7204600")},
            {"manu", new Guid("97FFFD48-2D1D-47A0-85A3-07FDE6FA0143")},
          };

        private static ErrorCode GetOptionParameter(ref string param, string[] args, int index)
        {
            if (index >= args.Length)
            {
                return new ErrorCode(ErrorCode.ErrorId.TooFewArgument, "'{0}' option need argument.", args[index - 1]);
            }
            param = args[index];

            return ErrorCode.Success;
        }

        public static ErrorCode Parse(ref ProgramOption option,string[] args)
        {
            if (args.Length < 1)
            {
                return new ErrorCode(ErrorCode.ErrorId.TooFewArgument, "Too few argument.");
            }

            for (int i = 0; i < args.Length; ++i)
            {
                switch (args[i])
                {
                    case "-g":
                    case "--guid":
                        {
                            i++;
                            string param = String.Empty;
                            var ret = GetOptionParameter(ref param, args, i);
                            if(ret.Id != ErrorCode.ErrorId.Success)
                            {
                                return ret;
                            }
                            option.UsbGuid = new Guid(param);
                        }
                        break;
                    case "-t":
                    case "--type":
                        {
                            i++;
                            string param = String.Empty;
                            var ret = GetOptionParameter(ref param, args, i);
                            if (ret.Id != ErrorCode.ErrorId.Success)
                            {
                                return ret;
                            }

                            if (param == "frcm" || param == "manu")
                            {
                                option.UsbGuid = UsbGuidList[param];
                            }
                            else
                            {
                                return new ErrorCode(ErrorCode.ErrorId.InvalidArgument, "Unknown device type : {0}", param);
                            }
                        }
                        break;
                    default:
                        return new ErrorCode(ErrorCode.ErrorId.InvalidArgument, "Unknown option '{0}'", args[i]);
                }
            }

            return ErrorCode.Success;
        }

        public static void PrintUsage()
        {
            var ProgramAssembly = Assembly.GetEntryAssembly();
            var ProgramName = ProgramAssembly.ManifestModule.Name;

            Console.WriteLine("[{0} Ver.{1}]", ProgramName, ProgramAssembly.GetName().Version);
            Console.WriteLine("Usage : {0} [Option]", ProgramName);
            Console.WriteLine("Option");
            Console.WriteLine("     -g, --guid <GUID>      : GUID を指定して、USB デバイスを列挙します");
            Console.WriteLine("     -t, --type <frcm|manu> : デバイスの種類を指定して、USB デバイスを列挙します");
            Console.WriteLine("     -v, --verbose          : ログたくさん（今は何も出ない）");
        }
    }
}
