﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class SvcTypeGenerator : SourceGenerator
    {
        public SvcTypeGenerator(CodeGenNames p) : base(p) { }

        public void Generate(SvcSet ss, string templatePath, string pathTemplate)
        {
            this.GenerateWithCategory(ss, null, null, null, templatePath, pathTemplate);
        }

        protected string Namespace
        {
            get
            {
                return string.Format("{0}::{1}", CodeGenNames.UserCommonNamespace, Params.TypeNamespace);
            }
        }

        protected override string Generate(CategorySet c,
            Dictionary<string, AbiLayout> abi,
            Dictionary<string, SvcLayout> svc,
            Dictionary<string, LayoutConversion> conv)
        {
            if (c.Types == null)
            {
                return null;
            }

            var sb = new StringBuilder();

            sb.Append(SourceGenerator.MakePragmaOnce());
            sb.AppendLine();
            if (c.Includes != null)
            {
                foreach (var inc in c.Includes)
                {
                    sb.Append(SourceGenerator.MakeIncludeLine(inc));
                }
            }
            sb.AppendLine();
            sb.Append(SourceGenerator.MakeNameSpaceBeginText(this.Namespace));
            sb.AppendLine();

            foreach (var type in c.Types)
            {
                var text = type.MakeText();
                sb.Append(SourceGenerator.Indent(text, "    "));
                sb.AppendLine();
            }

            sb.Append(SourceGenerator.MakeNameSpaceEndText(this.Namespace));
            sb.AppendLine();
            return sb.ToString();
        }
    }
}
