﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class LayoutConversionOperationScatter : LayoutConversion.Operation
    {
        // ABI: レジスタ上のアドレスが指すメモリ
        // SVC: レジスタ x N

        public LayoutConversionOperationScatter(int abiIndex, int[] svcIndex,
            int storageSize, int transSize, string name)
            : base("Scatter", abiIndex, svcIndex, storageSize, transSize, name)
        {
        }

        public override void GenerateCodeInAbiToSvc(
            CodeGenerator cg, RegisterUsageTracer tracer, int stackOffset)
        {
            Action loadToAbi = null;
            var index = 0;
            foreach (var si in this.SvcIndex)
            {
                var offset = index++ * StorageSize;
                if (si == this.AbiIndex)
                {
                    var indexCapture = index;
                    loadToAbi = () => cg.Load(si, this.AbiIndex, offset, TransferSize, this.VariableName, indexCapture);
                }
                else
                {
                    cg.Load(si, this.AbiIndex, offset, TransferSize, this.VariableName, index);
                }
            }
            if (loadToAbi != null)
            {
                loadToAbi();
            }
        }
        public override bool CanGenerateCodeInSvcToAbi(RegisterUsageTracer tracer)
        {
            foreach (var si in this.SvcIndex)
            {
                tracer.Release(si);
            }

            return tracer.TryOccupy(this.AbiIndex, "abi " + this.VariableName);
        }
        public override void GenerateCodeInSvcToAbi(
            CodeGenerator cg, RegisterUsageTracer tracer, Dictionary<int, int> storageMap)
        {
            var storageOffset = storageMap[AbiIndex];
            int index = 0;
            foreach (var si in this.SvcIndex)
            {
                var offset = storageOffset + (index++ * StorageSize);
                tracer.Release(si);
                cg.StoreToStack(si, offset, this.VariableName, index);
            }

            tracer.Occupy(this.AbiIndex, "abi " + this.VariableName);
            cg.LoadStackAddress(this.AbiIndex, storageOffset, this.VariableName);
        }
        public override void GenerateCodeOutPrepareToAbi(
            CodeGenerator cg, RegisterUsageTracer tracer, Dictionary<int, int> storageMap)
        {
            var storageOffset = storageMap[AbiIndex];

            int index = 0;
            foreach (var si in this.SvcIndex)
            {
                var offset = storageOffset + (index++ * StorageSize);
                tracer.Release(si);
                cg.StoreToStack(si, offset, this.VariableName, index);
            }

            tracer.Occupy(this.AbiIndex, "abi " + this.VariableName);
            cg.LoadStackAddress(this.AbiIndex, storageOffset, this.VariableName);
        }
        public override void GenerateCodeOutAbiToSvc(
            CodeGenerator cg, RegisterUsageTracer tracer, Dictionary<int, int> storageMap)
        {
            var storageOffset = storageMap[AbiIndex];

            int index = 0;
            foreach (var si in this.SvcIndex)
            {
                var offset = storageOffset + (index++ * StorageSize);
                cg.LoadFromStack(si, offset, this.VariableName, index);
            }
        }
        public override void GenerateCodeOutSvcToAbi(
            CodeGenerator cg,
            RegisterUsageTracer tracer,
            Dictionary<int, int> saveMap,
            int safeRegister,
            int stackOffset)
        {
            cg.LoadFromStack(safeRegister, saveMap[this.AbiIndex], this.VariableName + "のアドレス");

            int index = 0;
            foreach (var si in this.SvcIndex)
            {
                var offset = index++ * StorageSize;
                cg.Store(si, safeRegister, offset, TransferSize, this.VariableName, index);
            }
        }
    }
}
