﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeSvcVeneer
{
    internal class CodeGenParams
    {
        public enum ArchitectureType
        {
            Invariant,
            AArch32,
            AArch64,
        }
        public enum DataModels
        {
            Invariant,
            Ilp32,
            Lp64,
        }

        public int StorageSize { get; private set; }
        public int RegisterCount { get; private set; }
        public int VolatileRegisterCount { get; private set; }
        public int PointerSize { get; private set; }
        public int RegisterSize { get; private set; }
        public DataModels DataModel { get; private set; }
        public ArchitectureType Archtecture { get; private set; }

        public override string ToString()
        {
            return string.Format("{0} s={1} r={2} p={3}",
                Archtecture,
                StorageSize,
                RegisterCount,
                PointerSize);
        }

        private CodeGenParams(int s, int r, int v, int p, int rs, DataModels d, ArchitectureType u)
        {
            StorageSize = s;
            RegisterCount = r;
            VolatileRegisterCount = v;
            PointerSize = p;
            RegisterSize = rs;
            DataModel = d;
            Archtecture = u;
        }
        private CodeGenParams(int s, int r, int v, int p, int rs)
            : this(s, r, v, p, rs, DataModels.Invariant, ArchitectureType.Invariant)
        { }

        //                    StorageSize
        //                       RegisterCount
        //                          VolatileRegisterCount
        //                              PointerSize
        public static readonly CodeGenParams AArch32Abi =
            new CodeGenParams(4, 4,  4, 4, 4, DataModels.Ilp32, ArchitectureType.AArch32);

        public static readonly CodeGenParams AArch32Svc =
            new CodeGenParams(4, 8,  4, 4, 4);

        public static readonly CodeGenParams AArch64P32Abi =
            new CodeGenParams(8, 8, 18, 4, 8, DataModels.Ilp32, ArchitectureType.AArch64);

        public static readonly CodeGenParams AArch64P64Abi =
            new CodeGenParams(8, 8, 18, 8, 8, DataModels.Lp64, ArchitectureType.AArch64);

        public static readonly CodeGenParams AArch64Svc =
            new CodeGenParams(8, 8, 18, 8, 8);
    }
}
