﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace MakeSvcVeneer.Parser
{
    enum Token
    {
        token_eof,
        token_ABSTRACT,
        token_BRACE_LEFT,
        token_BRACE_RIGHT,
        token_BRACKET_LEFT,
        token_BRACKET_RIGHT,
        token_COMMA,
        token_COMMON,
        token_ENUM,
        token_EQUAL,
        token_IDENTIFIER,
        token_INCLUDES,
        token_LESS_THAN,
        token_NUMBER,
        token_OPERATIONS,
        token_PAREN_LEFT,
        token_PAREN_RIGHT,
        token_SEMICOLON,
        token_STRING,
        token_STRUCT,
        token_TYPEDEF,
        token_TYPES,
        token_TYPE_NAME,
        token_UNION,
    }

    interface ISemanticAction
    {
        void syntax_error(string expected);
        void stack_overflow();


        IncludeFileList MakeList(int pos, IncludeFileList arg1, string arg2);
        IncludeFileList MakeList(int pos, string arg1);
        Includes MakeIncludes(int pos, string arg1, IncludeFileList arg2);
        OperationContent MakeOperationContent(int pos, OperationDeclaration arg1);
        OperationContent MakeOperationContent(int pos, int arg1);
        OperationContentList MakeList(int pos, OperationContent arg1);
        OperationContentList MakeList(int pos, OperationContentList arg1, OperationContent arg2);
        OperationDeclaration MakeOperationDeclaration(int pos, OperationDeclaration arg1, OperationParameterList arg2);
        OperationDeclaration MakeOperationDeclaration(int pos, string arg1, string arg2);
        OperationDeclaration MakeOperationDeclaration(int pos, string arg1, string arg2, int arg3);
        OperationParameter MakeOperationParameter(int pos, string arg1, VariableDeclaration arg2);
        OperationParameterList MakeList(int pos, OperationParameter arg1);
        OperationParameterList MakeList(int pos, OperationParameterList arg1, OperationParameter arg2);
        OperationParameterList MakeOperationParameterList(int pos);
        OperationParameterList Pass(int pos, OperationParameterList arg1);
        Operations MakeOperations(int pos, string arg1, OperationContentList arg2);
        SvcDefinition MakeList(int pos, SvcDefinition arg1, SvcDefinitionContent arg2);
        SvcDefinition MakeList(int pos, SvcDefinitionContent arg1);
        SvcDefinitionContent MakeSvcDefinitionContent(int pos, Includes arg1);
        SvcDefinitionContent MakeSvcDefinitionContent(int pos, Operations arg1);
        SvcDefinitionContent MakeSvcDefinitionContent(int pos, Types arg1);
        TypeDeclaration MakeAbstractCommonTypeDeclaration(int pos, TypeDeclaration arg1);
        TypeDeclaration MakeAbstractTypeDeclaration(int pos, TypeDeclaration arg1);
        TypeDeclaration MakeTypeDeclarationAlias(int pos, string arg1, string arg2);
        TypeDeclaration MakeTypeDeclarationEnum(int pos, string arg1);
        TypeDeclaration MakeTypeDeclarationStruct(int pos, string arg1, VariableDeclarationList arg2);
        TypeDeclaration MakeTypeDeclarationUnion(int pos, string arg1, VariableDeclarationList arg2);
        TypeDeclaration Pass(int pos, TypeDeclaration arg1);
        TypeDeclarationList MakeList(int pos, TypeDeclaration arg1);
        TypeDeclarationList MakeList(int pos, TypeDeclarationList arg1, TypeDeclaration arg2);
        Types MakeTypes(int pos, string arg1, TypeDeclarationList arg2);
        VariableDeclaration MakeVariableDeclaration(int pos, string arg1, string arg2);
        VariableDeclaration MakeVariableDeclarationArray(int pos, string arg1, string arg2);
        VariableDeclaration MakeVariableDeclarationArray(int pos, string arg1, string arg2, int arg3);
        VariableDeclaration MakeVariableDeclarationArray(int pos, string arg1, string arg2, string arg3);
        VariableDeclarationList MakeList(int pos, VariableDeclaration arg1);
        VariableDeclarationList MakeList(int pos, VariableDeclarationList arg1, VariableDeclaration arg2);
        int MakeOperationNumber(int pos, string arg1, int arg2);
        string Pass(int pos, string arg1);
    }

    class Parser
    {
        public class stack_frame
        {
            public state_type state;
            public gotof_type gotof;
            public object value;

            public int pos;
            public string token;

            public stack_frame(state_type s, gotof_type g, object v, int p, string t)
            {
                state = s; gotof = g; value = v; pos = p; token = t;
            }
        }

        public class Stack
        {
            private List<stack_frame> stack = new List<stack_frame>();
            private List<stack_frame> tmp = new List<stack_frame>();
            private int gap;

            public Stack(){ this.gap = 0; }
            public void reset_tmp()
            {
                this.gap = this.stack.Count;
                this.tmp.Clear();
            }

            public void commit_tmp()
            {
                int size = this.gap + this.tmp.Count;
                if(size > this.stack.Capacity) this.stack.Capacity = size;
                this.stack.RemoveRange(this.gap, this.stack.Count - this.gap);
                this.stack.AddRange(this.tmp);
            }
            public bool push(stack_frame f)
            {
                this.tmp.Add(f);
                return true;
            }

            public void pop(int n)
            {
                if(this.tmp.Count < n)
                {
                n -= this.tmp.Count;
                this.tmp.Clear();
                this.gap -= n;
                }else
                {
                    this.tmp.RemoveRange(this.tmp.Count - n, n);
                }
            }

            public stack_frame top()
            {
                if( this.tmp.Count != 0 )
                {
                    return this.tmp[this.tmp.Count - 1];
                }else
                {
                    return this.stack[this.gap - 1];
                }
            }

            public stack_frame get_arg(int b, int i)
            {
                int n = this.tmp.Count;
                if(b - i <= n)
                {
                    return this.tmp[n - (b - i)];
                }else
                {
                    return this.stack[this.gap - (b - n) + i];
                }
            }

            public void clear()
            {
                this.stack.Clear();
            }

            public int get_stack_level()
            {
                return this.tmp.Count + this.gap;
            }

        } // class Stack

        public delegate bool state_type(Token token, object value, int pos);
        public delegate bool gotof_type(int i, object value, int pos);

        public Parser(ISemanticAction sa)
        {
            this.stack = new Stack();
            this.sa = sa;
            this.reset();
        }


        public void reset()
        {
            this.error = false;
            this.accepted = false;
            this.clear_stack();
            this.reset_tmp_stack();
            if( this.push_stack( this.state_0, this.gotof_0, new object(), -1, null) )
            {
                this.commit_tmp_stack();
            }else
            {
                this.sa.stack_overflow();
                this.error = true;
            }
        }
        public bool post(Token token,object value, int pos)
        {
            System.Diagnostics.Debug.Assert(!this.error);
            this.reset_tmp_stack();
            while(stack_top().state(token, value, pos));
            if( !this.error )
            {
                this.commit_tmp_stack();
            }
            return this.accepted;
        }

        public bool accept(out object v)
        {
            System.Diagnostics.Debug.Assert(this.accepted);
            if(this.error) { v = new object(); return false; }
            v = this.accepted_value;
            return true;
        }

        public bool Error() { return this.error; }

        private ISemanticAction sa;
        public Stack stack;
        private bool accepted;
        private bool error;
        private object accepted_value;

        private bool push_stack(state_type s, gotof_type g, object v, int p, string t)
        {
            bool f = this.stack.push(new stack_frame(s, g, v, p, t));
            System.Diagnostics.Debug.Assert(!this.error);
            if(!f)
            {
                this.error = true;
                this.sa.stack_overflow();
            }
            return f;
        }

        private void pop_stack(int n)
        {
            this.stack.pop(n);
        }

        private stack_frame stack_top()
        {
            return this.stack.top();
        }

        private object get_arg(int b, int i)
        {
            return stack.get_arg(b, i).value;
        }

        private int  get_pos(int b, int i)
        {
            return stack.get_arg(b, i).pos;
        }

        private void clear_stack()
        {
            this.stack.clear();
        }

        private void reset_tmp_stack()
        {
            this.stack.reset_tmp();
        }

        private void commit_tmp_stack()
        {
            this.stack.commit_tmp();
        }

        bool gotof_0(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 15: return push_stack( this.state_1, this.gotof_1, v, p, "svc_list" );
                case 16: return push_stack( this.state_2, this.gotof_2, v, p, "svc_list_content" );
                case 3: return push_stack( this.state_4, this.gotof_4, v, p, "includes" );
                case 19: return push_stack( this.state_5, this.gotof_5, v, p, "types" );
                case 12: return push_stack( this.state_6, this.gotof_6, v, p, "operations" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_0_expected = "INCLUDES OPERATIONS TYPES";

        bool state_0(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_INCLUDES:
                // shift
                push_stack( this.state_7, this.gotof_7, value, pos, "INCLUDES");
                return false;
            case Token.token_OPERATIONS:
                // shift
                push_stack( this.state_17, this.gotof_17, value, pos, "OPERATIONS");
                return false;
            case Token.token_TYPES:
                // shift
                push_stack( this.state_12, this.gotof_12, value, pos, "TYPES");
                return false;
            default:
                this.sa.syntax_error(state_0_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_1(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 16: return push_stack( this.state_3, this.gotof_3, v, p, "svc_list_content" );
                case 3: return push_stack( this.state_4, this.gotof_4, v, p, "includes" );
                case 19: return push_stack( this.state_5, this.gotof_5, v, p, "types" );
                case 12: return push_stack( this.state_6, this.gotof_6, v, p, "operations" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_1_expected = "eof INCLUDES OPERATIONS TYPES";

        bool state_1(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // accept
                // run_semantic_action();
                this.accepted = true;
                this.accepted_value  = get_arg( 1, 0 );
                return false;
            case Token.token_INCLUDES:
                // shift
                push_stack( this.state_7, this.gotof_7, value, pos, "INCLUDES");
                return false;
            case Token.token_OPERATIONS:
                // shift
                push_stack( this.state_17, this.gotof_17, value, pos, "OPERATIONS");
                return false;
            case Token.token_TYPES:
                // shift
                push_stack( this.state_12, this.gotof_12, value, pos, "TYPES");
                return false;
            default:
                this.sa.syntax_error(state_1_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_2(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_2_expected = "eof INCLUDES OPERATIONS TYPES";

        bool state_2(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    SvcDefinitionContent arg0 = (SvcDefinitionContent)get_arg(1, 0);
                    SvcDefinition r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(15, v, pos);
                }
            case Token.token_INCLUDES:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    SvcDefinitionContent arg0 = (SvcDefinitionContent)get_arg(1, 0);
                    SvcDefinition r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(15, v, pos);
                }
            case Token.token_OPERATIONS:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    SvcDefinitionContent arg0 = (SvcDefinitionContent)get_arg(1, 0);
                    SvcDefinition r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(15, v, pos);
                }
            case Token.token_TYPES:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    SvcDefinitionContent arg0 = (SvcDefinitionContent)get_arg(1, 0);
                    SvcDefinition r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(15, v, pos);
                }
            default:
                this.sa.syntax_error(state_2_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_3(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_3_expected = "eof INCLUDES OPERATIONS TYPES";

        bool state_3(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    SvcDefinition arg0 = (SvcDefinition)get_arg(2, 0);
                    SvcDefinitionContent arg1 = (SvcDefinitionContent)get_arg(2, 1);
                    SvcDefinition r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(15, v, pos);
                }
            case Token.token_INCLUDES:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    SvcDefinition arg0 = (SvcDefinition)get_arg(2, 0);
                    SvcDefinitionContent arg1 = (SvcDefinitionContent)get_arg(2, 1);
                    SvcDefinition r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(15, v, pos);
                }
            case Token.token_OPERATIONS:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    SvcDefinition arg0 = (SvcDefinition)get_arg(2, 0);
                    SvcDefinitionContent arg1 = (SvcDefinitionContent)get_arg(2, 1);
                    SvcDefinition r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(15, v, pos);
                }
            case Token.token_TYPES:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    SvcDefinition arg0 = (SvcDefinition)get_arg(2, 0);
                    SvcDefinitionContent arg1 = (SvcDefinitionContent)get_arg(2, 1);
                    SvcDefinition r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(15, v, pos);
                }
            default:
                this.sa.syntax_error(state_3_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_4(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_4_expected = "eof INCLUDES OPERATIONS TYPES";

        bool state_4(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Includes arg0 = (Includes)get_arg(1, 0);
                    SvcDefinitionContent r = this.sa.MakeSvcDefinitionContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            case Token.token_INCLUDES:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Includes arg0 = (Includes)get_arg(1, 0);
                    SvcDefinitionContent r = this.sa.MakeSvcDefinitionContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            case Token.token_OPERATIONS:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Includes arg0 = (Includes)get_arg(1, 0);
                    SvcDefinitionContent r = this.sa.MakeSvcDefinitionContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            case Token.token_TYPES:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Includes arg0 = (Includes)get_arg(1, 0);
                    SvcDefinitionContent r = this.sa.MakeSvcDefinitionContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            default:
                this.sa.syntax_error(state_4_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_5(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_5_expected = "eof INCLUDES OPERATIONS TYPES";

        bool state_5(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Types arg0 = (Types)get_arg(1, 0);
                    SvcDefinitionContent r = this.sa.MakeSvcDefinitionContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            case Token.token_INCLUDES:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Types arg0 = (Types)get_arg(1, 0);
                    SvcDefinitionContent r = this.sa.MakeSvcDefinitionContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            case Token.token_OPERATIONS:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Types arg0 = (Types)get_arg(1, 0);
                    SvcDefinitionContent r = this.sa.MakeSvcDefinitionContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            case Token.token_TYPES:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Types arg0 = (Types)get_arg(1, 0);
                    SvcDefinitionContent r = this.sa.MakeSvcDefinitionContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            default:
                this.sa.syntax_error(state_5_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_6(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_6_expected = "eof INCLUDES OPERATIONS TYPES";

        bool state_6(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Operations arg0 = (Operations)get_arg(1, 0);
                    SvcDefinitionContent r = this.sa.MakeSvcDefinitionContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            case Token.token_INCLUDES:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Operations arg0 = (Operations)get_arg(1, 0);
                    SvcDefinitionContent r = this.sa.MakeSvcDefinitionContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            case Token.token_OPERATIONS:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Operations arg0 = (Operations)get_arg(1, 0);
                    SvcDefinitionContent r = this.sa.MakeSvcDefinitionContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            case Token.token_TYPES:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    Operations arg0 = (Operations)get_arg(1, 0);
                    SvcDefinitionContent r = this.sa.MakeSvcDefinitionContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(16, v, pos);
                }
            default:
                this.sa.syntax_error(state_6_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_7(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 0: return push_stack( this.state_8, this.gotof_8, v, p, "category_name" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_7_expected = "IDENTIFIER";

        bool state_7(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_48, this.gotof_48, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_7_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_8(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_8_expected = "BRACE_LEFT";

        bool state_8(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // shift
                push_stack( this.state_9, this.gotof_9, value, pos, "BRACE_LEFT");
                return false;
            default:
                this.sa.syntax_error(state_8_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_9(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 2: return push_stack( this.state_10, this.gotof_10, v, p, "include_file_list" );
                case 1: return push_stack( this.state_26, this.gotof_26, v, p, "include_file" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_9_expected = "STRING";

        bool state_9(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_STRING:
                // shift
                push_stack( this.state_49, this.gotof_49, value, pos, "STRING");
                return false;
            default:
                this.sa.syntax_error(state_9_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_10(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 1: return push_stack( this.state_27, this.gotof_27, v, p, "include_file" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_10_expected = "BRACE_RIGHT STRING";

        bool state_10(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // shift
                push_stack( this.state_11, this.gotof_11, value, pos, "BRACE_RIGHT");
                return false;
            case Token.token_STRING:
                // shift
                push_stack( this.state_49, this.gotof_49, value, pos, "STRING");
                return false;
            default:
                this.sa.syntax_error(state_10_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_11(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_11_expected = "eof INCLUDES OPERATIONS TYPES";

        bool state_11(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 1);
                    IncludeFileList arg1 = (IncludeFileList)get_arg(5, 3);
                    Includes r = this.sa.MakeIncludes(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(3, v, pos);
                }
            case Token.token_INCLUDES:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 1);
                    IncludeFileList arg1 = (IncludeFileList)get_arg(5, 3);
                    Includes r = this.sa.MakeIncludes(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(3, v, pos);
                }
            case Token.token_OPERATIONS:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 1);
                    IncludeFileList arg1 = (IncludeFileList)get_arg(5, 3);
                    Includes r = this.sa.MakeIncludes(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(3, v, pos);
                }
            case Token.token_TYPES:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 1);
                    IncludeFileList arg1 = (IncludeFileList)get_arg(5, 3);
                    Includes r = this.sa.MakeIncludes(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(3, v, pos);
                }
            default:
                this.sa.syntax_error(state_11_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_12(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 0: return push_stack( this.state_13, this.gotof_13, v, p, "category_name" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_12_expected = "IDENTIFIER";

        bool state_12(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_48, this.gotof_48, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_12_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_13(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_13_expected = "BRACE_LEFT";

        bool state_13(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // shift
                push_stack( this.state_14, this.gotof_14, value, pos, "BRACE_LEFT");
                return false;
            default:
                this.sa.syntax_error(state_13_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_14(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 18: return push_stack( this.state_15, this.gotof_15, v, p, "type_declaration_list" );
                case 13: return push_stack( this.state_28, this.gotof_28, v, p, "qualified_type_declaration" );
                case 17: return push_stack( this.state_50, this.gotof_50, v, p, "type_declaration" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_14_expected = "ABSTRACT ENUM STRUCT TYPEDEF UNION";

        bool state_14(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_ABSTRACT:
                // shift
                push_stack( this.state_51, this.gotof_51, value, pos, "ABSTRACT");
                return false;
            case Token.token_ENUM:
                // shift
                push_stack( this.state_63, this.gotof_63, value, pos, "ENUM");
                return false;
            case Token.token_STRUCT:
                // shift
                push_stack( this.state_55, this.gotof_55, value, pos, "STRUCT");
                return false;
            case Token.token_TYPEDEF:
                // shift
                push_stack( this.state_66, this.gotof_66, value, pos, "TYPEDEF");
                return false;
            case Token.token_UNION:
                // shift
                push_stack( this.state_59, this.gotof_59, value, pos, "UNION");
                return false;
            default:
                this.sa.syntax_error(state_14_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_15(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 13: return push_stack( this.state_29, this.gotof_29, v, p, "qualified_type_declaration" );
                case 17: return push_stack( this.state_50, this.gotof_50, v, p, "type_declaration" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_15_expected = "ABSTRACT BRACE_RIGHT ENUM STRUCT TYPEDEF UNION";

        bool state_15(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_ABSTRACT:
                // shift
                push_stack( this.state_51, this.gotof_51, value, pos, "ABSTRACT");
                return false;
            case Token.token_BRACE_RIGHT:
                // shift
                push_stack( this.state_16, this.gotof_16, value, pos, "BRACE_RIGHT");
                return false;
            case Token.token_ENUM:
                // shift
                push_stack( this.state_63, this.gotof_63, value, pos, "ENUM");
                return false;
            case Token.token_STRUCT:
                // shift
                push_stack( this.state_55, this.gotof_55, value, pos, "STRUCT");
                return false;
            case Token.token_TYPEDEF:
                // shift
                push_stack( this.state_66, this.gotof_66, value, pos, "TYPEDEF");
                return false;
            case Token.token_UNION:
                // shift
                push_stack( this.state_59, this.gotof_59, value, pos, "UNION");
                return false;
            default:
                this.sa.syntax_error(state_15_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_16(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_16_expected = "eof INCLUDES OPERATIONS TYPES";

        bool state_16(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 1);
                    TypeDeclarationList arg1 = (TypeDeclarationList)get_arg(5, 3);
                    Types r = this.sa.MakeTypes(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(19, v, pos);
                }
            case Token.token_INCLUDES:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 1);
                    TypeDeclarationList arg1 = (TypeDeclarationList)get_arg(5, 3);
                    Types r = this.sa.MakeTypes(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(19, v, pos);
                }
            case Token.token_OPERATIONS:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 1);
                    TypeDeclarationList arg1 = (TypeDeclarationList)get_arg(5, 3);
                    Types r = this.sa.MakeTypes(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(19, v, pos);
                }
            case Token.token_TYPES:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 1);
                    TypeDeclarationList arg1 = (TypeDeclarationList)get_arg(5, 3);
                    Types r = this.sa.MakeTypes(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(19, v, pos);
                }
            default:
                this.sa.syntax_error(state_16_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_17(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 0: return push_stack( this.state_18, this.gotof_18, v, p, "category_name" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_17_expected = "IDENTIFIER";

        bool state_17(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_48, this.gotof_48, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_17_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_18(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_18_expected = "BRACE_LEFT";

        bool state_18(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // shift
                push_stack( this.state_19, this.gotof_19, value, pos, "BRACE_LEFT");
                return false;
            default:
                this.sa.syntax_error(state_18_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_19(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 5: return push_stack( this.state_30, this.gotof_30, v, p, "operation_content" );
                case 6: return push_stack( this.state_20, this.gotof_20, v, p, "operation_content_list" );
                case 14: return push_stack( this.state_24, this.gotof_24, v, p, "set_next_operation_number" );
                case 7: return push_stack( this.state_22, this.gotof_22, v, p, "operation_declaration" );
                case 8: return push_stack( this.state_79, this.gotof_79, v, p, "operation_declaration_0" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_19_expected = "IDENTIFIER TYPE_NAME";

        bool state_19(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_45, this.gotof_45, value, pos, "IDENTIFIER");
                return false;
            case Token.token_TYPE_NAME:
                // shift
                push_stack( this.state_81, this.gotof_81, value, pos, "TYPE_NAME");
                return false;
            default:
                this.sa.syntax_error(state_19_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_20(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 5: return push_stack( this.state_31, this.gotof_31, v, p, "operation_content" );
                case 14: return push_stack( this.state_24, this.gotof_24, v, p, "set_next_operation_number" );
                case 7: return push_stack( this.state_22, this.gotof_22, v, p, "operation_declaration" );
                case 8: return push_stack( this.state_79, this.gotof_79, v, p, "operation_declaration_0" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_20_expected = "BRACE_RIGHT IDENTIFIER TYPE_NAME";

        bool state_20(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // shift
                push_stack( this.state_21, this.gotof_21, value, pos, "BRACE_RIGHT");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_45, this.gotof_45, value, pos, "IDENTIFIER");
                return false;
            case Token.token_TYPE_NAME:
                // shift
                push_stack( this.state_81, this.gotof_81, value, pos, "TYPE_NAME");
                return false;
            default:
                this.sa.syntax_error(state_20_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_21(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_21_expected = "eof INCLUDES OPERATIONS TYPES";

        bool state_21(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_eof:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 1);
                    OperationContentList arg1 = (OperationContentList)get_arg(5, 3);
                    Operations r = this.sa.MakeOperations(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(12, v, pos);
                }
            case Token.token_INCLUDES:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 1);
                    OperationContentList arg1 = (OperationContentList)get_arg(5, 3);
                    Operations r = this.sa.MakeOperations(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(12, v, pos);
                }
            case Token.token_OPERATIONS:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 1);
                    OperationContentList arg1 = (OperationContentList)get_arg(5, 3);
                    Operations r = this.sa.MakeOperations(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(12, v, pos);
                }
            case Token.token_TYPES:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 1);
                    OperationContentList arg1 = (OperationContentList)get_arg(5, 3);
                    Operations r = this.sa.MakeOperations(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(12, v, pos);
                }
            default:
                this.sa.syntax_error(state_21_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_22(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_22_expected = "SEMICOLON";

        bool state_22(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_SEMICOLON:
                // shift
                push_stack( this.state_23, this.gotof_23, value, pos, "SEMICOLON");
                return false;
            default:
                this.sa.syntax_error(state_22_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_23(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_23_expected = "BRACE_RIGHT IDENTIFIER TYPE_NAME";

        bool state_23(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    OperationDeclaration arg0 = (OperationDeclaration)get_arg(2, 0);
                    OperationContent r = this.sa.MakeOperationContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(5, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    OperationDeclaration arg0 = (OperationDeclaration)get_arg(2, 0);
                    OperationContent r = this.sa.MakeOperationContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(5, v, pos);
                }
            case Token.token_TYPE_NAME:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    OperationDeclaration arg0 = (OperationDeclaration)get_arg(2, 0);
                    OperationContent r = this.sa.MakeOperationContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(5, v, pos);
                }
            default:
                this.sa.syntax_error(state_23_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_24(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_24_expected = "SEMICOLON";

        bool state_24(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_SEMICOLON:
                // shift
                push_stack( this.state_25, this.gotof_25, value, pos, "SEMICOLON");
                return false;
            default:
                this.sa.syntax_error(state_24_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_25(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_25_expected = "BRACE_RIGHT IDENTIFIER TYPE_NAME";

        bool state_25(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    int arg0 = (int)get_arg(2, 0);
                    OperationContent r = this.sa.MakeOperationContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(5, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    int arg0 = (int)get_arg(2, 0);
                    OperationContent r = this.sa.MakeOperationContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(5, v, pos);
                }
            case Token.token_TYPE_NAME:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    int arg0 = (int)get_arg(2, 0);
                    OperationContent r = this.sa.MakeOperationContent(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(5, v, pos);
                }
            default:
                this.sa.syntax_error(state_25_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_26(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_26_expected = "BRACE_RIGHT STRING";

        bool state_26(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    string arg0 = (string)get_arg(1, 0);
                    IncludeFileList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(2, v, pos);
                }
            case Token.token_STRING:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    string arg0 = (string)get_arg(1, 0);
                    IncludeFileList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(2, v, pos);
                }
            default:
                this.sa.syntax_error(state_26_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_27(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_27_expected = "BRACE_RIGHT STRING";

        bool state_27(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    IncludeFileList arg0 = (IncludeFileList)get_arg(2, 0);
                    string arg1 = (string)get_arg(2, 1);
                    IncludeFileList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(2, v, pos);
                }
            case Token.token_STRING:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    IncludeFileList arg0 = (IncludeFileList)get_arg(2, 0);
                    string arg1 = (string)get_arg(2, 1);
                    IncludeFileList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(2, v, pos);
                }
            default:
                this.sa.syntax_error(state_27_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_28(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_28_expected = "ABSTRACT BRACE_RIGHT ENUM STRUCT TYPEDEF UNION";

        bool state_28(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_ABSTRACT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(1, 0);
                    TypeDeclarationList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(1, 0);
                    TypeDeclarationList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_ENUM:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(1, 0);
                    TypeDeclarationList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_STRUCT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(1, 0);
                    TypeDeclarationList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_TYPEDEF:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(1, 0);
                    TypeDeclarationList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_UNION:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(1, 0);
                    TypeDeclarationList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(18, v, pos);
                }
            default:
                this.sa.syntax_error(state_28_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_29(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_29_expected = "ABSTRACT BRACE_RIGHT ENUM STRUCT TYPEDEF UNION";

        bool state_29(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_ABSTRACT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    TypeDeclarationList arg0 = (TypeDeclarationList)get_arg(2, 0);
                    TypeDeclaration arg1 = (TypeDeclaration)get_arg(2, 1);
                    TypeDeclarationList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    TypeDeclarationList arg0 = (TypeDeclarationList)get_arg(2, 0);
                    TypeDeclaration arg1 = (TypeDeclaration)get_arg(2, 1);
                    TypeDeclarationList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_ENUM:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    TypeDeclarationList arg0 = (TypeDeclarationList)get_arg(2, 0);
                    TypeDeclaration arg1 = (TypeDeclaration)get_arg(2, 1);
                    TypeDeclarationList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_STRUCT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    TypeDeclarationList arg0 = (TypeDeclarationList)get_arg(2, 0);
                    TypeDeclaration arg1 = (TypeDeclaration)get_arg(2, 1);
                    TypeDeclarationList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_TYPEDEF:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    TypeDeclarationList arg0 = (TypeDeclarationList)get_arg(2, 0);
                    TypeDeclaration arg1 = (TypeDeclaration)get_arg(2, 1);
                    TypeDeclarationList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(18, v, pos);
                }
            case Token.token_UNION:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    TypeDeclarationList arg0 = (TypeDeclarationList)get_arg(2, 0);
                    TypeDeclaration arg1 = (TypeDeclaration)get_arg(2, 1);
                    TypeDeclarationList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(18, v, pos);
                }
            default:
                this.sa.syntax_error(state_29_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_30(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_30_expected = "BRACE_RIGHT IDENTIFIER TYPE_NAME";

        bool state_30(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    OperationContent arg0 = (OperationContent)get_arg(1, 0);
                    OperationContentList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(6, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    OperationContent arg0 = (OperationContent)get_arg(1, 0);
                    OperationContentList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(6, v, pos);
                }
            case Token.token_TYPE_NAME:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    OperationContent arg0 = (OperationContent)get_arg(1, 0);
                    OperationContentList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(6, v, pos);
                }
            default:
                this.sa.syntax_error(state_30_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_31(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_31_expected = "BRACE_RIGHT IDENTIFIER TYPE_NAME";

        bool state_31(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    OperationContentList arg0 = (OperationContentList)get_arg(2, 0);
                    OperationContent arg1 = (OperationContent)get_arg(2, 1);
                    OperationContentList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(6, v, pos);
                }
            case Token.token_IDENTIFIER:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    OperationContentList arg0 = (OperationContentList)get_arg(2, 0);
                    OperationContent arg1 = (OperationContent)get_arg(2, 1);
                    OperationContentList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(6, v, pos);
                }
            case Token.token_TYPE_NAME:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    OperationContentList arg0 = (OperationContentList)get_arg(2, 0);
                    OperationContent arg1 = (OperationContent)get_arg(2, 1);
                    OperationContentList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(6, v, pos);
                }
            default:
                this.sa.syntax_error(state_31_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_32(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 4: return push_stack( this.state_36, this.gotof_36, v, p, "member_list" );
                case 20: return push_stack( this.state_34, this.gotof_34, v, p, "variable_declaration" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_32_expected = "TYPE_NAME";

        bool state_32(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_TYPE_NAME:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "TYPE_NAME");
                return false;
            default:
                this.sa.syntax_error(state_32_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_33(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 4: return push_stack( this.state_37, this.gotof_37, v, p, "member_list" );
                case 20: return push_stack( this.state_34, this.gotof_34, v, p, "variable_declaration" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_33_expected = "TYPE_NAME";

        bool state_33(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_TYPE_NAME:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "TYPE_NAME");
                return false;
            default:
                this.sa.syntax_error(state_33_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_34(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_34_expected = "SEMICOLON";

        bool state_34(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_SEMICOLON:
                // shift
                push_stack( this.state_35, this.gotof_35, value, pos, "SEMICOLON");
                return false;
            default:
                this.sa.syntax_error(state_34_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_35(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_35_expected = "BRACE_RIGHT TYPE_NAME";

        bool state_35(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    VariableDeclaration arg0 = (VariableDeclaration)get_arg(2, 0);
                    VariableDeclarationList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(4, v, pos);
                }
            case Token.token_TYPE_NAME:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    VariableDeclaration arg0 = (VariableDeclaration)get_arg(2, 0);
                    VariableDeclarationList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(4, v, pos);
                }
            default:
                this.sa.syntax_error(state_35_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_36(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 20: return push_stack( this.state_38, this.gotof_38, v, p, "variable_declaration" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_36_expected = "BRACE_RIGHT TYPE_NAME";

        bool state_36(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // shift
                push_stack( this.state_57, this.gotof_57, value, pos, "BRACE_RIGHT");
                return false;
            case Token.token_TYPE_NAME:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "TYPE_NAME");
                return false;
            default:
                this.sa.syntax_error(state_36_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_37(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 20: return push_stack( this.state_38, this.gotof_38, v, p, "variable_declaration" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_37_expected = "BRACE_RIGHT TYPE_NAME";

        bool state_37(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // shift
                push_stack( this.state_61, this.gotof_61, value, pos, "BRACE_RIGHT");
                return false;
            case Token.token_TYPE_NAME:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "TYPE_NAME");
                return false;
            default:
                this.sa.syntax_error(state_37_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_38(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_38_expected = "SEMICOLON";

        bool state_38(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_SEMICOLON:
                // shift
                push_stack( this.state_39, this.gotof_39, value, pos, "SEMICOLON");
                return false;
            default:
                this.sa.syntax_error(state_38_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_39(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_39_expected = "BRACE_RIGHT TYPE_NAME";

        bool state_39(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    VariableDeclarationList arg0 = (VariableDeclarationList)get_arg(3, 0);
                    VariableDeclaration arg1 = (VariableDeclaration)get_arg(3, 1);
                    VariableDeclarationList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(4, v, pos);
                }
            case Token.token_TYPE_NAME:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    VariableDeclarationList arg0 = (VariableDeclarationList)get_arg(3, 0);
                    VariableDeclaration arg1 = (VariableDeclaration)get_arg(3, 1);
                    VariableDeclarationList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(4, v, pos);
                }
            default:
                this.sa.syntax_error(state_39_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_40(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 11: return push_stack( this.state_42, this.gotof_42, v, p, "operation_parameter_list" );
                case 10: return push_stack( this.state_41, this.gotof_41, v, p, "operation_parameter" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_40_expected = "IDENTIFIER PAREN_RIGHT";

        bool state_40(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_70, this.gotof_70, value, pos, "IDENTIFIER");
                return false;
            case Token.token_PAREN_RIGHT:
                // shift
                push_stack( this.state_85, this.gotof_85, value, pos, "PAREN_RIGHT");
                return false;
            default:
                this.sa.syntax_error(state_40_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_41(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_41_expected = "COMMA PAREN_RIGHT";

        bool state_41(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    OperationParameter arg0 = (OperationParameter)get_arg(1, 0);
                    OperationParameterList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(11, v, pos);
                }
            case Token.token_PAREN_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    OperationParameter arg0 = (OperationParameter)get_arg(1, 0);
                    OperationParameterList r = this.sa.MakeList(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(11, v, pos);
                }
            default:
                this.sa.syntax_error(state_41_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_42(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_42_expected = "COMMA PAREN_RIGHT";

        bool state_42(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_COMMA:
                // shift
                push_stack( this.state_43, this.gotof_43, value, pos, "COMMA");
                return false;
            case Token.token_PAREN_RIGHT:
                // shift
                push_stack( this.state_86, this.gotof_86, value, pos, "PAREN_RIGHT");
                return false;
            default:
                this.sa.syntax_error(state_42_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_43(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 10: return push_stack( this.state_44, this.gotof_44, v, p, "operation_parameter" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_43_expected = "IDENTIFIER";

        bool state_43(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_70, this.gotof_70, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_43_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_44(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_44_expected = "COMMA PAREN_RIGHT";

        bool state_44(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    OperationParameterList arg0 = (OperationParameterList)get_arg(3, 0);
                    OperationParameter arg1 = (OperationParameter)get_arg(3, 2);
                    OperationParameterList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(11, v, pos);
                }
            case Token.token_PAREN_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    OperationParameterList arg0 = (OperationParameterList)get_arg(3, 0);
                    OperationParameter arg1 = (OperationParameter)get_arg(3, 2);
                    OperationParameterList r = this.sa.MakeList(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(11, v, pos);
                }
            default:
                this.sa.syntax_error(state_44_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_45(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_45_expected = "EQUAL";

        bool state_45(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_EQUAL:
                // shift
                push_stack( this.state_46, this.gotof_46, value, pos, "EQUAL");
                return false;
            default:
                this.sa.syntax_error(state_45_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_46(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_46_expected = "NUMBER";

        bool state_46(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_NUMBER:
                // shift
                push_stack( this.state_47, this.gotof_47, value, pos, "NUMBER");
                return false;
            default:
                this.sa.syntax_error(state_46_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_47(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_47_expected = "SEMICOLON";

        bool state_47(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    string arg0 = (string)get_arg(3, 0);
                    int arg1 = (int)get_arg(3, 2);
                    int r = this.sa.MakeOperationNumber(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(14, v, pos);
                }
            default:
                this.sa.syntax_error(state_47_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_48(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_48_expected = "BRACE_LEFT";

        bool state_48(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    string arg0 = (string)get_arg(1, 0);
                    string r = this.sa.Pass(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(0, v, pos);
                }
            default:
                this.sa.syntax_error(state_48_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_49(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_49_expected = "BRACE_RIGHT STRING";

        bool state_49(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    string arg0 = (string)get_arg(1, 0);
                    string r = this.sa.Pass(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(1, v, pos);
                }
            case Token.token_STRING:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    string arg0 = (string)get_arg(1, 0);
                    string r = this.sa.Pass(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(1, v, pos);
                }
            default:
                this.sa.syntax_error(state_49_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_50(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_50_expected = "ABSTRACT BRACE_RIGHT ENUM STRUCT TYPEDEF UNION";

        bool state_50(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_ABSTRACT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(1, 0);
                    TypeDeclaration r = this.sa.Pass(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(1, 0);
                    TypeDeclaration r = this.sa.Pass(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_ENUM:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(1, 0);
                    TypeDeclaration r = this.sa.Pass(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_STRUCT:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(1, 0);
                    TypeDeclaration r = this.sa.Pass(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_TYPEDEF:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(1, 0);
                    TypeDeclaration r = this.sa.Pass(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_UNION:
                // reduce
                {
                    int firstPos = get_pos(1, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(1, 0);
                    TypeDeclaration r = this.sa.Pass(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 1);
                    return stack_top().gotof(13, v, pos);
                }
            default:
                this.sa.syntax_error(state_50_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_51(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 17: return push_stack( this.state_52, this.gotof_52, v, p, "type_declaration" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_51_expected = "COMMON ENUM STRUCT TYPEDEF UNION";

        bool state_51(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_COMMON:
                // shift
                push_stack( this.state_53, this.gotof_53, value, pos, "COMMON");
                return false;
            case Token.token_ENUM:
                // shift
                push_stack( this.state_63, this.gotof_63, value, pos, "ENUM");
                return false;
            case Token.token_STRUCT:
                // shift
                push_stack( this.state_55, this.gotof_55, value, pos, "STRUCT");
                return false;
            case Token.token_TYPEDEF:
                // shift
                push_stack( this.state_66, this.gotof_66, value, pos, "TYPEDEF");
                return false;
            case Token.token_UNION:
                // shift
                push_stack( this.state_59, this.gotof_59, value, pos, "UNION");
                return false;
            default:
                this.sa.syntax_error(state_51_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_52(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_52_expected = "ABSTRACT BRACE_RIGHT ENUM STRUCT TYPEDEF UNION";

        bool state_52(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_ABSTRACT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(2, 1);
                    TypeDeclaration r = this.sa.MakeAbstractTypeDeclaration(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(2, 1);
                    TypeDeclaration r = this.sa.MakeAbstractTypeDeclaration(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_ENUM:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(2, 1);
                    TypeDeclaration r = this.sa.MakeAbstractTypeDeclaration(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_STRUCT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(2, 1);
                    TypeDeclaration r = this.sa.MakeAbstractTypeDeclaration(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_TYPEDEF:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(2, 1);
                    TypeDeclaration r = this.sa.MakeAbstractTypeDeclaration(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_UNION:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(2, 1);
                    TypeDeclaration r = this.sa.MakeAbstractTypeDeclaration(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(13, v, pos);
                }
            default:
                this.sa.syntax_error(state_52_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_53(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 17: return push_stack( this.state_54, this.gotof_54, v, p, "type_declaration" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_53_expected = "ENUM STRUCT TYPEDEF UNION";

        bool state_53(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_ENUM:
                // shift
                push_stack( this.state_63, this.gotof_63, value, pos, "ENUM");
                return false;
            case Token.token_STRUCT:
                // shift
                push_stack( this.state_55, this.gotof_55, value, pos, "STRUCT");
                return false;
            case Token.token_TYPEDEF:
                // shift
                push_stack( this.state_66, this.gotof_66, value, pos, "TYPEDEF");
                return false;
            case Token.token_UNION:
                // shift
                push_stack( this.state_59, this.gotof_59, value, pos, "UNION");
                return false;
            default:
                this.sa.syntax_error(state_53_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_54(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_54_expected = "ABSTRACT BRACE_RIGHT ENUM STRUCT TYPEDEF UNION";

        bool state_54(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_ABSTRACT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(3, 2);
                    TypeDeclaration r = this.sa.MakeAbstractCommonTypeDeclaration(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(3, 2);
                    TypeDeclaration r = this.sa.MakeAbstractCommonTypeDeclaration(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_ENUM:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(3, 2);
                    TypeDeclaration r = this.sa.MakeAbstractCommonTypeDeclaration(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_STRUCT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(3, 2);
                    TypeDeclaration r = this.sa.MakeAbstractCommonTypeDeclaration(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_TYPEDEF:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(3, 2);
                    TypeDeclaration r = this.sa.MakeAbstractCommonTypeDeclaration(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(13, v, pos);
                }
            case Token.token_UNION:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    TypeDeclaration arg0 = (TypeDeclaration)get_arg(3, 2);
                    TypeDeclaration r = this.sa.MakeAbstractCommonTypeDeclaration(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(13, v, pos);
                }
            default:
                this.sa.syntax_error(state_54_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_55(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_55_expected = "IDENTIFIER";

        bool state_55(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_56, this.gotof_56, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_55_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_56(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_56_expected = "BRACE_LEFT";

        bool state_56(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // shift
                push_stack( this.state_32, this.gotof_32, value, pos, "BRACE_LEFT");
                return false;
            default:
                this.sa.syntax_error(state_56_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_57(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_57_expected = "SEMICOLON";

        bool state_57(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_SEMICOLON:
                // shift
                push_stack( this.state_58, this.gotof_58, value, pos, "SEMICOLON");
                return false;
            default:
                this.sa.syntax_error(state_57_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_58(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_58_expected = "ABSTRACT BRACE_RIGHT ENUM STRUCT TYPEDEF UNION";

        bool state_58(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_ABSTRACT:
                // reduce
                {
                    int firstPos = get_pos(6, 0);
                    string arg0 = (string)get_arg(6, 1);
                    VariableDeclarationList arg1 = (VariableDeclarationList)get_arg(6, 3);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationStruct(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 6);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(6, 0);
                    string arg0 = (string)get_arg(6, 1);
                    VariableDeclarationList arg1 = (VariableDeclarationList)get_arg(6, 3);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationStruct(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 6);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_ENUM:
                // reduce
                {
                    int firstPos = get_pos(6, 0);
                    string arg0 = (string)get_arg(6, 1);
                    VariableDeclarationList arg1 = (VariableDeclarationList)get_arg(6, 3);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationStruct(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 6);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_STRUCT:
                // reduce
                {
                    int firstPos = get_pos(6, 0);
                    string arg0 = (string)get_arg(6, 1);
                    VariableDeclarationList arg1 = (VariableDeclarationList)get_arg(6, 3);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationStruct(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 6);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_TYPEDEF:
                // reduce
                {
                    int firstPos = get_pos(6, 0);
                    string arg0 = (string)get_arg(6, 1);
                    VariableDeclarationList arg1 = (VariableDeclarationList)get_arg(6, 3);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationStruct(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 6);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_UNION:
                // reduce
                {
                    int firstPos = get_pos(6, 0);
                    string arg0 = (string)get_arg(6, 1);
                    VariableDeclarationList arg1 = (VariableDeclarationList)get_arg(6, 3);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationStruct(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 6);
                    return stack_top().gotof(17, v, pos);
                }
            default:
                this.sa.syntax_error(state_58_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_59(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_59_expected = "IDENTIFIER";

        bool state_59(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_60, this.gotof_60, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_59_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_60(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_60_expected = "BRACE_LEFT";

        bool state_60(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACE_LEFT:
                // shift
                push_stack( this.state_33, this.gotof_33, value, pos, "BRACE_LEFT");
                return false;
            default:
                this.sa.syntax_error(state_60_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_61(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_61_expected = "SEMICOLON";

        bool state_61(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_SEMICOLON:
                // shift
                push_stack( this.state_62, this.gotof_62, value, pos, "SEMICOLON");
                return false;
            default:
                this.sa.syntax_error(state_61_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_62(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_62_expected = "ABSTRACT BRACE_RIGHT ENUM STRUCT TYPEDEF UNION";

        bool state_62(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_ABSTRACT:
                // reduce
                {
                    int firstPos = get_pos(6, 0);
                    string arg0 = (string)get_arg(6, 1);
                    VariableDeclarationList arg1 = (VariableDeclarationList)get_arg(6, 3);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationUnion(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 6);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(6, 0);
                    string arg0 = (string)get_arg(6, 1);
                    VariableDeclarationList arg1 = (VariableDeclarationList)get_arg(6, 3);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationUnion(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 6);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_ENUM:
                // reduce
                {
                    int firstPos = get_pos(6, 0);
                    string arg0 = (string)get_arg(6, 1);
                    VariableDeclarationList arg1 = (VariableDeclarationList)get_arg(6, 3);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationUnion(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 6);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_STRUCT:
                // reduce
                {
                    int firstPos = get_pos(6, 0);
                    string arg0 = (string)get_arg(6, 1);
                    VariableDeclarationList arg1 = (VariableDeclarationList)get_arg(6, 3);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationUnion(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 6);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_TYPEDEF:
                // reduce
                {
                    int firstPos = get_pos(6, 0);
                    string arg0 = (string)get_arg(6, 1);
                    VariableDeclarationList arg1 = (VariableDeclarationList)get_arg(6, 3);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationUnion(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 6);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_UNION:
                // reduce
                {
                    int firstPos = get_pos(6, 0);
                    string arg0 = (string)get_arg(6, 1);
                    VariableDeclarationList arg1 = (VariableDeclarationList)get_arg(6, 3);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationUnion(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 6);
                    return stack_top().gotof(17, v, pos);
                }
            default:
                this.sa.syntax_error(state_62_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_63(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_63_expected = "IDENTIFIER";

        bool state_63(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_64, this.gotof_64, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_63_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_64(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_64_expected = "SEMICOLON";

        bool state_64(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_SEMICOLON:
                // shift
                push_stack( this.state_65, this.gotof_65, value, pos, "SEMICOLON");
                return false;
            default:
                this.sa.syntax_error(state_64_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_65(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_65_expected = "ABSTRACT BRACE_RIGHT ENUM STRUCT TYPEDEF UNION";

        bool state_65(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_ABSTRACT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    string arg0 = (string)get_arg(3, 1);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationEnum(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    string arg0 = (string)get_arg(3, 1);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationEnum(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_ENUM:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    string arg0 = (string)get_arg(3, 1);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationEnum(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_STRUCT:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    string arg0 = (string)get_arg(3, 1);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationEnum(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_TYPEDEF:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    string arg0 = (string)get_arg(3, 1);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationEnum(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_UNION:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    string arg0 = (string)get_arg(3, 1);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationEnum(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(17, v, pos);
                }
            default:
                this.sa.syntax_error(state_65_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_66(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_66_expected = "TYPE_NAME";

        bool state_66(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_TYPE_NAME:
                // shift
                push_stack( this.state_67, this.gotof_67, value, pos, "TYPE_NAME");
                return false;
            default:
                this.sa.syntax_error(state_66_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_67(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_67_expected = "IDENTIFIER";

        bool state_67(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_68, this.gotof_68, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_67_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_68(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_68_expected = "SEMICOLON";

        bool state_68(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_SEMICOLON:
                // shift
                push_stack( this.state_69, this.gotof_69, value, pos, "SEMICOLON");
                return false;
            default:
                this.sa.syntax_error(state_68_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_69(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_69_expected = "ABSTRACT BRACE_RIGHT ENUM STRUCT TYPEDEF UNION";

        bool state_69(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_ABSTRACT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    string arg0 = (string)get_arg(4, 1);
                    string arg1 = (string)get_arg(4, 2);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationAlias(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_BRACE_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    string arg0 = (string)get_arg(4, 1);
                    string arg1 = (string)get_arg(4, 2);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationAlias(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_ENUM:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    string arg0 = (string)get_arg(4, 1);
                    string arg1 = (string)get_arg(4, 2);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationAlias(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_STRUCT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    string arg0 = (string)get_arg(4, 1);
                    string arg1 = (string)get_arg(4, 2);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationAlias(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_TYPEDEF:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    string arg0 = (string)get_arg(4, 1);
                    string arg1 = (string)get_arg(4, 2);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationAlias(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(17, v, pos);
                }
            case Token.token_UNION:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    string arg0 = (string)get_arg(4, 1);
                    string arg1 = (string)get_arg(4, 2);
                    TypeDeclaration r = this.sa.MakeTypeDeclarationAlias(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(17, v, pos);
                }
            default:
                this.sa.syntax_error(state_69_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_70(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 20: return push_stack( this.state_87, this.gotof_87, v, p, "variable_declaration" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_70_expected = "TYPE_NAME";

        bool state_70(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_TYPE_NAME:
                // shift
                push_stack( this.state_71, this.gotof_71, value, pos, "TYPE_NAME");
                return false;
            default:
                this.sa.syntax_error(state_70_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_71(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_71_expected = "IDENTIFIER";

        bool state_71(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_72, this.gotof_72, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_71_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_72(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_72_expected = "BRACKET_LEFT COMMA PAREN_RIGHT SEMICOLON";

        bool state_72(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_LEFT:
                // shift
                push_stack( this.state_73, this.gotof_73, value, pos, "BRACKET_LEFT");
                return false;
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    string arg0 = (string)get_arg(2, 0);
                    string arg1 = (string)get_arg(2, 1);
                    VariableDeclaration r = this.sa.MakeVariableDeclaration(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_PAREN_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    string arg0 = (string)get_arg(2, 0);
                    string arg1 = (string)get_arg(2, 1);
                    VariableDeclaration r = this.sa.MakeVariableDeclaration(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    string arg0 = (string)get_arg(2, 0);
                    string arg1 = (string)get_arg(2, 1);
                    VariableDeclaration r = this.sa.MakeVariableDeclaration(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(20, v, pos);
                }
            default:
                this.sa.syntax_error(state_72_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_73(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_73_expected = "BRACKET_RIGHT IDENTIFIER NUMBER";

        bool state_73(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // shift
                push_stack( this.state_74, this.gotof_74, value, pos, "BRACKET_RIGHT");
                return false;
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_77, this.gotof_77, value, pos, "IDENTIFIER");
                return false;
            case Token.token_NUMBER:
                // shift
                push_stack( this.state_75, this.gotof_75, value, pos, "NUMBER");
                return false;
            default:
                this.sa.syntax_error(state_73_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_74(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_74_expected = "COMMA PAREN_RIGHT SEMICOLON";

        bool state_74(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    string arg0 = (string)get_arg(4, 0);
                    string arg1 = (string)get_arg(4, 1);
                    VariableDeclaration r = this.sa.MakeVariableDeclarationArray(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_PAREN_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    string arg0 = (string)get_arg(4, 0);
                    string arg1 = (string)get_arg(4, 1);
                    VariableDeclaration r = this.sa.MakeVariableDeclarationArray(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    string arg0 = (string)get_arg(4, 0);
                    string arg1 = (string)get_arg(4, 1);
                    VariableDeclaration r = this.sa.MakeVariableDeclarationArray(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(20, v, pos);
                }
            default:
                this.sa.syntax_error(state_74_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_75(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_75_expected = "BRACKET_RIGHT";

        bool state_75(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // shift
                push_stack( this.state_76, this.gotof_76, value, pos, "BRACKET_RIGHT");
                return false;
            default:
                this.sa.syntax_error(state_75_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_76(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_76_expected = "COMMA PAREN_RIGHT SEMICOLON";

        bool state_76(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 0);
                    string arg1 = (string)get_arg(5, 1);
                    int arg2 = (int)get_arg(5, 3);
                    VariableDeclaration r = this.sa.MakeVariableDeclarationArray(firstPos, arg0, arg1, arg2);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_PAREN_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 0);
                    string arg1 = (string)get_arg(5, 1);
                    int arg2 = (int)get_arg(5, 3);
                    VariableDeclaration r = this.sa.MakeVariableDeclarationArray(firstPos, arg0, arg1, arg2);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 0);
                    string arg1 = (string)get_arg(5, 1);
                    int arg2 = (int)get_arg(5, 3);
                    VariableDeclaration r = this.sa.MakeVariableDeclarationArray(firstPos, arg0, arg1, arg2);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(20, v, pos);
                }
            default:
                this.sa.syntax_error(state_76_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_77(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_77_expected = "BRACKET_RIGHT";

        bool state_77(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_BRACKET_RIGHT:
                // shift
                push_stack( this.state_78, this.gotof_78, value, pos, "BRACKET_RIGHT");
                return false;
            default:
                this.sa.syntax_error(state_77_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_78(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_78_expected = "COMMA PAREN_RIGHT SEMICOLON";

        bool state_78(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 0);
                    string arg1 = (string)get_arg(5, 1);
                    string arg2 = (string)get_arg(5, 3);
                    VariableDeclaration r = this.sa.MakeVariableDeclarationArray(firstPos, arg0, arg1, arg2);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_PAREN_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 0);
                    string arg1 = (string)get_arg(5, 1);
                    string arg2 = (string)get_arg(5, 3);
                    VariableDeclaration r = this.sa.MakeVariableDeclarationArray(firstPos, arg0, arg1, arg2);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(20, v, pos);
                }
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(5, 0);
                    string arg0 = (string)get_arg(5, 0);
                    string arg1 = (string)get_arg(5, 1);
                    string arg2 = (string)get_arg(5, 3);
                    VariableDeclaration r = this.sa.MakeVariableDeclarationArray(firstPos, arg0, arg1, arg2);
                    object v = (object)r;
                    pop_stack( 5);
                    return stack_top().gotof(20, v, pos);
                }
            default:
                this.sa.syntax_error(state_78_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_79(int nonterminal_index, object v, int p)
        {
            switch(nonterminal_index)
            {
                case 9: return push_stack( this.state_80, this.gotof_80, v, p, "operation_declaration_1" );
                default: System.Diagnostics.Debug.Assert(false); return false;
            }
        }

        private static string state_79_expected = "PAREN_LEFT";

        bool state_79(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_PAREN_LEFT:
                // shift
                push_stack( this.state_40, this.gotof_40, value, pos, "PAREN_LEFT");
                return false;
            default:
                this.sa.syntax_error(state_79_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_80(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_80_expected = "SEMICOLON";

        bool state_80(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    OperationDeclaration arg0 = (OperationDeclaration)get_arg(2, 0);
                    OperationParameterList arg1 = (OperationParameterList)get_arg(2, 1);
                    OperationDeclaration r = this.sa.MakeOperationDeclaration(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(7, v, pos);
                }
            default:
                this.sa.syntax_error(state_80_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_81(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_81_expected = "IDENTIFIER";

        bool state_81(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_IDENTIFIER:
                // shift
                push_stack( this.state_82, this.gotof_82, value, pos, "IDENTIFIER");
                return false;
            default:
                this.sa.syntax_error(state_81_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_82(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_82_expected = "EQUAL PAREN_LEFT";

        bool state_82(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_EQUAL:
                // shift
                push_stack( this.state_83, this.gotof_83, value, pos, "EQUAL");
                return false;
            case Token.token_PAREN_LEFT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    string arg0 = (string)get_arg(2, 0);
                    string arg1 = (string)get_arg(2, 1);
                    OperationDeclaration r = this.sa.MakeOperationDeclaration(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(8, v, pos);
                }
            default:
                this.sa.syntax_error(state_82_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_83(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_83_expected = "NUMBER";

        bool state_83(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_NUMBER:
                // shift
                push_stack( this.state_84, this.gotof_84, value, pos, "NUMBER");
                return false;
            default:
                this.sa.syntax_error(state_83_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_84(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_84_expected = "PAREN_LEFT";

        bool state_84(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_PAREN_LEFT:
                // reduce
                {
                    int firstPos = get_pos(4, 0);
                    string arg0 = (string)get_arg(4, 0);
                    string arg1 = (string)get_arg(4, 1);
                    int arg2 = (int)get_arg(4, 3);
                    OperationDeclaration r = this.sa.MakeOperationDeclaration(firstPos, arg0, arg1, arg2);
                    object v = (object)r;
                    pop_stack( 4);
                    return stack_top().gotof(8, v, pos);
                }
            default:
                this.sa.syntax_error(state_84_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_85(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_85_expected = "SEMICOLON";

        bool state_85(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = pos;
                    OperationParameterList r = this.sa.MakeOperationParameterList(firstPos);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(9, v, pos);
                }
            default:
                this.sa.syntax_error(state_85_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_86(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_86_expected = "SEMICOLON";

        bool state_86(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_SEMICOLON:
                // reduce
                {
                    int firstPos = get_pos(3, 0);
                    OperationParameterList arg0 = (OperationParameterList)get_arg(3, 1);
                    OperationParameterList r = this.sa.Pass(firstPos, arg0);
                    object v = (object)r;
                    pop_stack( 3);
                    return stack_top().gotof(9, v, pos);
                }
            default:
                this.sa.syntax_error(state_86_expected);
                this.error = true;
                return false;
            }
        }

        bool gotof_87(int nonterminal_index, object v, int p)
        {
            System.Diagnostics.Debug.Assert(false);
            return true;
        }

        private static string state_87_expected = "COMMA PAREN_RIGHT";

        bool state_87(Token token, object value, int pos)
        {
            switch(token)
            {
            case Token.token_COMMA:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    string arg0 = (string)get_arg(2, 0);
                    VariableDeclaration arg1 = (VariableDeclaration)get_arg(2, 1);
                    OperationParameter r = this.sa.MakeOperationParameter(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(10, v, pos);
                }
            case Token.token_PAREN_RIGHT:
                // reduce
                {
                    int firstPos = get_pos(2, 0);
                    string arg0 = (string)get_arg(2, 0);
                    VariableDeclaration arg1 = (VariableDeclaration)get_arg(2, 1);
                    OperationParameter r = this.sa.MakeOperationParameter(firstPos, arg0, arg1);
                    object v = (object)r;
                    pop_stack( 2);
                    return stack_top().gotof(10, v, pos);
                }
            default:
                this.sa.syntax_error(state_87_expected);
                this.error = true;
                return false;
            }
        }

    } // class Parser

} // namespace MakeSvcVeneer.Parser
