﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using Nintendo.Foundation.IO;

namespace MakeNso
{
    /// <summary>
    /// プログラムの引数からパラメータを設定するクラスです。
    /// </summary>
    internal class MakeNsoArgs
    {
        private MakeNsoParams parameters;
        public MakeNsoParams Params
        {
            get { return parameters; }
        }

        /// <summary>
        /// プログラムの引数からパラメータを設定します。
        /// </summary>
        /// <param name="args">プログラムの引数</param>
        /// <returns>パラメータ設定の可否</returns>
        public bool ParseArgs(string[] args)
        {
            var setttings = new CommandLineParserSettings()
            {
                ApplicationDescription = "MakeNso converts DSO file to NSO file.",
                HelpWriter = text =>
                {
                    Console.WriteLine(text);
                },
            };

            if (!new CommandLineParser(setttings).ParseArgs(args, out parameters))
            {
                return false;
            }

            if (parameters.ModuleName == null)
            {
                parameters.ModuleName = Path.GetFileNameWithoutExtension(parameters.OutputFileName);
                Console.WriteLine(parameters.OutputFileName);
            }

            if (parameters.Compress && parameters.NoCompress)
            {
                return false;
            }

            return true;
        }
    }
}
