﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Nintendo.Foundation.IO;

namespace MakeNro
{
    /// <summary>
    /// コマンドラインオプションを設定するクラスです。
    /// </summary>
    internal class MakeNroParams
    {
        [CommandLineOption("verbose",
            DefaultValue = false,
            Description = "Show log")
        ]
        public bool VerboseMode { get; set; }

        [CommandLineValue(0, ValueName = "INPUT_FILE", Description = "Input filename.")]
        public string DsoFileName { get; set; }

        [CommandLineValue(1, ValueName = "OUTPUT_FILE", Description = "Output filename.")]
        public string NroFileName { get; set; }
    }
}
