﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeMeta
{
    public class OptionVariable
    {
        public string VariableName { get; private set; }
        public string VariableLine { get; private set; }
        public string ValueLine { get; private set; }

        public OptionVariable(string option)
        {
            string[] args = option.Split('=');
            if (args == null || args.Count() != 2)
            {
                throw new ArgumentException(Properties.Resources.Message_InvalidOptionVariableFormat);
            }

            VariableName = args[0].Trim();
            ValueLine = args[1].Trim();
            VariableLine = string.Format("${{{0}}}", VariableName);
        }
    }
}
