﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Xml;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace MakeMeta
{
    using FacData = MakeDesc.FacData;

    public class FacDataGenerator
    {
        public static FacData Merge(MetaModel.MetaModel meta, DescModel.OutputDescModel desc)
        {
            FacData fac = new FacData();
            if (meta != null && meta.FsAccessControlData != null)
            {
                // meta に記述がある場合はそちらのみ利用
                fac.ImportFacData(meta.FsAccessControlData);
                return fac;
            }
            else if (desc != null && desc.Default != null && desc.Default.FsAccessControlData != null)
            {
                // desc の Default 記述を利用
                fac.ImportFacData(desc.Default.FsAccessControlData);
                return fac;
            }
            else
            {
                return null;
            }
        }
    }
}
