﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace MakeInitialProgram
{
    using System;

    /// <summary>
    /// ログメッセージを出力する機能を提供します。
    /// </summary>
    internal static class Logging
    {
        static Logging()
        {
            IsEnable = false;
        }

        /// <summary>
        /// ログメッセージを有効にするかどうかを示す値を設定します。
        /// </summary>
        internal static bool IsEnable { private get; set; }

        /// <summary>
        /// ログメッセージとして行終端記号を出力します。
        /// </summary>
        internal static void WriteLine()
        {
            if (Logging.IsEnable)
            {
                Console.WriteLine();
            }
        }

        /// <summary>
        /// 指定された値をログメッセージとして出力し、続けて行終端記号を出力します。
        /// </summary>
        /// <param name="value">出力する値です。</param>
        internal static void WriteLine(dynamic value)
        {
            if (Logging.IsEnable)
            {
                Console.WriteLine(value);
            }
        }

        /// <summary>
        /// 指定された書式指定文字列を使用して、指定されたオブジェクトの配列をログメッセージとして出力し、続けて行終端記号を出力します。
        /// </summary>
        /// <param name="format">書式指定文字列です。</param>
        /// <param name="args">format を使用して出力するオブジェクトの配列です。</param>
        internal static void WriteLine(string format, params object[] args)
        {
            if (Logging.IsEnable)
            {
                Console.WriteLine(format, args);
            }
        }
    }
}
