﻿using System;
using System.Xml;

namespace DescModel
{
    [System.Xml.Serialization.XmlRoot("Entry")]
    public class SaEntry
    {
        [System.Xml.Serialization.XmlIgnore]
        public bool IsServerValue;
        private string _IsServer;
        [System.Xml.Serialization.XmlElement("IsServer", IsNullable=false)]
        public string IsServer
        {
            get { return _IsServer; }
            set
            {
                if (value == null)
                {
                    return;
                }
                IsServerValue = ConvertUtils.ConvertBoolString(value, "Entry/IsServer");
                _IsServer = Convert.ToBoolean(IsServerValue).ToString();
            }
        }

        private string _Name;
        [System.Xml.Serialization.XmlElement("Name", IsNullable=false)]
        public string Name
        {
            get { return _Name; }
            set
            {
                if (value == null)
                {
                    return;
                }
                if (value.Length > 8)
                {
                    throw new ArgumentException(string.Format(Properties.Resources.Message_InvalidStringLength, "Entry/Name", 9));
                }
                if (value.Length == 0)
                {
                    throw new ArgumentException(string.Format(Properties.Resources.Message_NotFound, "Entry/Name"));
                }
                _Name = value;
            }
        }
    }
}
