﻿using System;
using System.Collections.Generic;
using System.Xml;
using System.Security.Cryptography;

namespace DescModel
{
    [System.Xml.Serialization.XmlRoot("Desc", IsNullable=false)]
    public class OutputDescModel
    {
        [System.Xml.Serialization.XmlElement("MemoryRegion")]
        public byte MemoryRegionValue { get; set; }

        [System.Xml.Serialization.XmlIgnore]
        public UInt64 ProgramIdMinValue { get; set; }
        private string _ProgramIdMin;

        [System.Xml.Serialization.XmlElement("ProgramIdMin")]
        public string ProgramIdMin
        {
            get { return _ProgramIdMin; }
            set
            {
                if (value == null)
                {
                    return;
                }
                ProgramIdMinValue = ConvertUtils.ConvertHexString(value, "Desc/ProgramIdMin");
                _ProgramIdMin = value;
            }
        }

        [System.Xml.Serialization.XmlIgnore]
        public UInt64 ProgramIdMaxValue { get; set; }
        private string _ProgramIdMax;
        [System.Xml.Serialization.XmlElement("ProgramIdMax")]
        public string ProgramIdMax
        {
            get { return _ProgramIdMax; }
            set
            {
                if (value == null)
                {
                    return;
                }
                ProgramIdMaxValue = ConvertUtils.ConvertHexString(value, "Desc/ProgramIdMax");
                _ProgramIdMax = value;
            }
        }

        [System.Xml.Serialization.XmlElement("FsAccessControlDescriptor")]
        public FaDescriptorModel FsAccessControlDescriptor { get; set; }

        [System.Xml.Serialization.XmlElement("SrvAccessControlDescriptor")]
        public SaDescriptorModel SrvAccessControlDescriptor { get; set; }

        [System.Xml.Serialization.XmlElement("KernelCapabilityDescriptor")]
        public KcDescriptorModelWithSvcInfo KernelCapabilityDescriptor { get; set; }

        [System.Xml.Serialization.XmlElement("Default", IsNullable=false)]
        public DefaultModelWithSvcInfo Default { get; set; }

        [System.Xml.Serialization.XmlElement("RSAKeyValue")]
        public RSAParameters RSAKeyValue { get; set; }

        public bool ShouldSerializeRSAKeyValue()
        {
            if (RSAKeyValue.Modulus == null)
            {
                return false;
            }
            return true;
        }

        [System.Xml.Serialization.XmlElement("Acid", IsNullable=false)]
        public string Acid { get; set; }
    }
}
