﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace MakeByteArray
{
    public class Program
    {
        public static void Main(string[] args)
        {
            if (args.Length < 2)
            {
                Console.WriteLine("Usage : MakeByteArray [input_file] [output_file]");
                return;
            }

            var input = args[0];
            var output = args[1];

            if (!File.Exists(input))
            {
                Console.WriteLine($"{input} does not exists.");
            }

            StreamWriter writer = new StreamWriter(output, false, Encoding.UTF8);

            using (BinaryReader reader = new BinaryReader(new FileStream(input, FileMode.Open, FileAccess.Read)))
            {
                try
                {
                    while (true)
                    {
                        var byteValue = reader.ReadByte();
                        writer.Write($"{byteValue}u,");
                    }
                }
                catch (EndOfStreamException)
                {
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.ToString());
                }
            }
            writer.Flush();
            writer.Close();
        }
    }
}
