﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using HtcDaemon.Native;

namespace HtcDaemon.Usb
{
    public class UsbProber
    {
        private Guid targetGuid;

        public UsbProber(Guid targetGuid)
        {
            this.targetGuid = targetGuid;
        }

        public bool Probe(out string devicePath)
        {
            devicePath = string.Empty;

            using (var deviceInfoHandle =
                NativeMethods.SetupDiGetClassDevs(
                    ref this.targetGuid,
                    IntPtr.Zero,
                    IntPtr.Zero,
                    (uint)(NativeMethods.DIGCF_PRESENT | NativeMethods.DIGCF_DEVICEINTERFACE)))
            {
                if (deviceInfoHandle.IsInvalid)
                {
                    var e = new Win32Exception();
                    throw new DeviceNotFoundException(
                        string.Format("デバイス {0} が見つかりません。: {1}", this.targetGuid, e.Message),
                        e);
                }

                var interfaceData = new NativeMethods.SP_DEVICE_INTERFACE_DATA();
                interfaceData.cbSize = Marshal.SizeOf(interfaceData);
                NativeMethods.SetupDiEnumDeviceInterfaces(
                    deviceInfoHandle,
                    IntPtr.Zero,
                    ref this.targetGuid,
                    0,
                    ref interfaceData);

                if (Marshal.GetLastWin32Error() == NativeMethods.Win32Error.ERROR_NO_MORE_ITEMS)
                {
                    return false;
                }

                if (!NativeMethods.SetupDiGetDeviceInterfaceDetail(deviceInfoHandle, ref interfaceData, out devicePath))
                {
                    throw new Win32Exception();
                }
            }

            return true;
        }
    }
}
