﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace HtcDaemon
{
    internal class TargetListenerTcp
    {
        private CancellationTokenSource cancellationTokenSource = new CancellationTokenSource();
        private Thread listenThread;
        private Socket listenSocket;

        public event EventHandler<TargetConnectedEventArgs> TargetConnected;

        public TargetListenerTcp()
        {
            this.listenThread = new Thread(ListenThread) { Name = "TargetListener" };
            this.listenSocket = MakeListenSocket();
        }

        private Socket MakeListenSocket()
        {
            var socket = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
            socket.Bind(new IPEndPoint(IPAddress.Any, HtcConstants.TargetListenTcpPort));
            socket.Listen(1);
            return socket;
        }

        public void Start()
        {
            listenThread.Start();
        }

        public void Stop()
        {
            cancellationTokenSource.Cancel();
        }

        private void ListenThread()
        {
            while (!cancellationTokenSource.IsCancellationRequested)
            {
                if (listenSocket.Poll(1000 * 1000, SelectMode.SelectRead))
                {
                    var socket = listenSocket.Accept();
                    RaiseConnected(socket);
                }
            }
        }

        private void RaiseConnected(Socket socket)
        {
            if (TargetConnected != null)
            {
                TargetConnected(this, new TargetConnectedEventArgs(socket));
            }
        }
    }
}
