﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using HtcDaemon.Bridging;
using Nintendo.Htcs;

namespace HtcDaemon.SerialConnection
{
    internal class SerialConnectionControlCommunicator : ControlCommunicator
    {
        private HtcsPeerName targetPeerName;

        public SerialConnectionControlCommunicator(Mux mux)
            : base(mux)
        {
            this.targetPeerName = mux.TargetPeerName;
        }

        protected override IHostAppListener CreateHostAppListener(string htcsPortName, int dummy)
        {
            // TORIAEZU: dummy は DirectSocket で使用する、ターゲット側で listen する場合のポートなので、無視する

            // TORIAEZU:
            int port;
            if (ProgramConfiguration.StaticPortMap.TryGetValue(
                new HtcsPortDescriptor(targetPeerName, htcsPortName), out port))
            {
                return new ProxyHostAppListener(htcsPortName, port);
            }
            else
            {
                return new ProxyHostAppListener(htcsPortName, 0);
            }
        }
    }
}
