﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace HtcDaemon
{
    internal class FlowController
    {
        private uint remoteBufferLength;
        private uint ackedSeq;
        private uint sentSeq;

        public uint RemoteBufferLength { get { return remoteBufferLength; } }
        public uint AckedSeq { get { return ackedSeq; } }
        public uint SentSeq { get { return sentSeq; } }

        public FlowController(uint remoteBufferLength)
        {
            this.remoteBufferLength = remoteBufferLength;
        }

        public void SetAckedSeq(uint ackedSeq)
        {
            this.ackedSeq = ackedSeq;
        }

        public void AddSentSeq(uint dataLength)
        {
            sentSeq += dataLength;
        }

        public uint GetSendableLength()
        {
            return remoteBufferLength - (sentSeq - ackedSeq);
        }
    }
}
