﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Nintendo.Authoring.AuthoringLibrary;
using Nintendo.Authoring.FileSystemMetaLibrary;

namespace Nintendo.FsFileCacheSimulator.FileSystem
{
    internal static class Utility
    {
        public static string GetMountName(string path)
        {
            return path.Substring(0, path.IndexOf(':'));
        }

        public static string GetFileSystemName(string path)
        {
            return path.Substring(path.IndexOf(':') + 1).TrimStart('/', '\\');
        }

        public static IReadOnlyDictionary<string, FileRegion> GetRomFsOffsetTable(string inputNspFilePath, string originalNspFilePath = null, string keyConfigFilePath = null)
        {
            using (var inputNspFileStream = new FileStream(inputNspFilePath, FileMode.Open, FileAccess.Read, FileShare.Read))
            using (var originalNspFileStream = originalNspFilePath != null ? new FileStream(originalNspFilePath, FileMode.Open, FileAccess.Read, FileShare.Read) : null)
            {
                using (var inputNspReader = new NintendoSubmissionPackageReader(inputNspFileStream))
                using (var originalNspReader = originalNspFileStream != null ? new NintendoSubmissionPackageReader(originalNspFileStream) : null)
                {
                    foreach (var nspInfo in inputNspReader.ListFileInfo())
                    {
                        var fileNameInNsp = nspInfo.Item1;
                        if (Path.GetExtension(fileNameInNsp) != ".nca")
                        {
                            continue;
                        }

                        var keyConfig = new KeyConfiguration();
                        if (keyConfigFilePath != null)
                        {
                            keyConfig.SetKey(keyConfigFilePath);
                        }
                        var keyGenerator = new NcaKeyGenerator(keyConfig);

                        NintendoContentArchiveReader inputNcaReader;
                        NintendoContentArchiveReader originalNcaReader;
                        if (originalNspReader != null)
                        {
                            var nca = new NintendoSubmissionPackageComparer(originalNspReader, inputNspReader, keyConfig);
                            nca.FindOriginal(fileNameInNsp, out originalNcaReader, out inputNcaReader);
                        }
                        else
                        {
                            inputNcaReader = inputNspReader.OpenNintendoContentArchiveReader(fileNameInNsp, keyGenerator);
                        }
                        TicketUtility.SetExternalKey(ref inputNcaReader, inputNspReader);

                        if (inputNcaReader.GetContentType() != NintendoContentFileSystemMetaConstant.ContentTypeProgram)
                        {
                            continue;
                        }

                        foreach (var ncaInfo in inputNcaReader.ListFsInfo())
                        {
                            var fsIndexInNca = ncaInfo.Item1;
                            if ((NintendoContentArchivePartitionType)fsIndexInNca != NintendoContentArchivePartitionType.Data)
                            {
                                continue;
                            }

                            using (var fsReader = inputNcaReader.OpenFileSystemArchiveReader(fsIndexInNca))
                            {
                                var ret = new Dictionary<string, FileRegion>();

                                foreach (var fsInfo in fsReader.ListFileInfo())
                                {
                                    var fileNameInFs = fsInfo.Item1;
                                    var fileFragment = fsReader.GetFileFragmentList(fileNameInFs).Single();
                                    var fileOffsetInFs = fileFragment.Item1;
                                    var fileSizeInFs = fileFragment.Item2;
                                    if (fileOffsetInFs < 0)
                                    {
                                        throw new NotImplementedException();
                                    }
                                    ret.Add(fileNameInFs, new FileRegion((ulong)fileOffsetInFs, (ulong)fileSizeInFs));
                                }

                                return ret;
                            }
                        }
                    }
                }
            }
            throw new ArgumentException($"nsp ファイル '{inputNspFilePath}' から RomFs を見つけることができませんでした");
        }
    }
}
