﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

// LibFdtDll.cpp : DLL アプリケーション用にエクスポートされる関数を定義します。
//

#include "stdafx.h"

#include "LibFdtDll.h"

extern "C"
{
#include "libfdt.h"
}

int FdtCheckHeader(const void *fdt)
{
    return fdt_check_header(fdt);
}

int FdtPathOffset(const void *fdt, const char *path)
{
    return fdt_path_offset(fdt, path);
}

int FdtNodeOffsetByPhandle(const void *fdt, uint32_t phandle)
{
    return fdt_node_offset_by_phandle(fdt, phandle);
}

int FdtNodeOffsetByCompatible(const void *fdt, int startoffset, const char *compatible)
{
    return fdt_node_offset_by_compatible(fdt, startoffset, compatible);
}

int FdtParentOffset(const void *fdt, int nodeoffset)
{
    return fdt_parent_offset(fdt, nodeoffset);
}

// 元の libfdt の API はポインタを直接返すが、代わりに fdt 上のオフセットを返すことにする
int FdtGetprop(const void *fdt, int nodeoffset, const char *name, int *lenp)
{
    auto* pProperty = fdt_getprop(fdt, nodeoffset, name, lenp);
    if ( pProperty == nullptr )
    {
        // fdt_getprop 失敗時は lenp にエラーコードが格納される仕様
        return *lenp;
    }
    return static_cast<int>(reinterpret_cast<uintptr_t>(pProperty) - reinterpret_cast<uintptr_t>(fdt));
}

int FdtAddressCells(const void *fdt, int nodeoffset)
{
    return fdt_address_cells(fdt, nodeoffset);
}

int FdtSizeCells(const void *fdt, int nodeoffset)
{
    return fdt_size_cells(fdt, nodeoffset);
}

// 元の libfdt の API は文字列へのポインタを直接返すが、渡されたバッファに格納する形式にする
int FdtStrerror(int errval, char* buffer, size_t bufferSize)
{
    const char* errString = fdt_strerror(errval);
    if ( !buffer || !errString )
    {
        return 0;
    }
    strncpy_s(buffer, bufferSize, errString, strlen(errString));
    return strlen(buffer);
}
