﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
namespace MakeDataDocument
{
    /// <summary>
    /// このプログラムのエントリポイントのクラスです。
    /// </summary>
    internal class Program
    {
        /// <summary>
        /// このプログラムのエントリポイントです。
        /// </summary>
        /// <param name="args">プログラム引数です。</param>
        private static void Main(string[] args)
        {
            if (args.Length != 1)
            {
                Console.Error.WriteLine("usage: MakeDataDocument <document_definition_file>");
                Environment.Exit(1);
            }

            try
            {
                GenerateDocumentData(args[0]);
            }
            catch (Exception e)
            {
                Console.Error.WriteLine("内部エラー : {0}", e.Message);
                Console.Error.WriteLine(string.Empty);
                Console.Error.WriteLine("== Exception ==");
                Console.Error.WriteLine(string.Empty);
                Console.Error.WriteLine(e.ToString());

                Environment.Exit(1);
            }
        }

        /// <summary>
        /// ドキュメント定義ファイルを元に、ドキュメントデータを生成します。
        /// </summary>
        /// <param name="documentDefinitionFilePath"></param>
        private static void GenerateDocumentData(string documentDefinitionFilePath)
        {
            var dataDocumentDefinition = DataDocumentDefinition.MakeFromJsonFile(documentDefinitionFilePath);
            var dataDocumentGenerator = new DataDocumentGenerator(dataDocumentDefinition);

            dataDocumentGenerator.GenerateVisualizableDataAsJsonFile();
        }
    }
}
