﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Nintendo.Foundation.IO;

namespace ContentsUploader
{
    public class ContentsUploaderArgument
    {
        [CommandLineSubCommand("upload", Description = "upload nsp file")]
        public Commands.UploadCommand UploadCommand { get; set; }

        [CommandLineSubCommand("password", Description = "get login_id and password of token")]
        public Commands.PasswordCommand PasswordCommand { get; set; }

        [CommandLineSubCommand("register-title", Description = "register title")]
        public Commands.RegisterTitleCommand RegisterTitleCommand { get; set; }

        [CommandLineSubCommand("register-demo", Description = "register rom for pms")]
        public Commands.RegisterDemoCommand RegisterDemoCommand { get; set; }

        [CommandLineSubCommand("register-bundle", Description = "register bundle")]
        public Commands.RegisterBundleCommand RegisterBundleCommand { get; set; }

        [CommandLineSubCommand("register-version", Description = "register version for superfly")]
        public Commands.RegisterVersionCommand RegisterVersionCommand { get; set; }

        [CommandLineSubCommand("delete-version", Description = "delete version for superfly")]
        public Commands.DeleteVersionCommand DeleteVersionCommand { get; set; }

        [CommandLineSubCommand("list-version", Description = "list version for superfly")]
        public Commands.ListVersionCommand ListVersionCommand { get; set; }

        [CommandLineSubCommand("list-rom-id", Description = "list rom ids of an input application id")]
        public Commands.ListRomIdCommand ListRomIdCommand { get; set; }

        [CommandLineSubCommand("revoke-rom", Description = "revoke APPROVED status on server")]
        public Commands.RevokeRomCommand RevokeRomCommand { get; set; }

        [CommandLineSubCommand("stop-delivery", Description = "stop delivery")]
        public Commands.StopDeliveryCommand StopDeliveryCommand { get; set; }

        [CommandLineSubCommand("restart-delivery", Description = "restart delivery")]
        public Commands.RestartDeliveryCommand RestartDeliveryCommand { get; set; }

        // 操作対象コマンドを取得
        public Commands.CommandBase GetActiveCommand()
        {
            foreach (var property in GetType().GetProperties())
            {
                var command = property.GetValue(this) as Commands.CommandBase;
                if (command != null)
                {
                    return command;
                }
            }
            return null;
        }
    }

    public class Program
    {
        public static void Main(string[] args)
        {
#if !DEBUG
            try
            {
#endif
            if (args == null || args.Length == 0)
            {
                args = new string[] { "help" };
            }
            var parameters = new ContentsUploaderArgument();
            if (CommandLineParser.Default.ParseArgs<ContentsUploaderArgument>(args, out parameters))
            {
                // 自己署名証明書を使ったサーバー相手に通信を許可
                System.Net.ServicePointManager.ServerCertificateValidationCallback += (sender, cert, chain, sslPolicyErrors) => true;

                // 引数で指定されたコマンドを実行
                var command = parameters.GetActiveCommand();
                if (command != null)
                {
                    command.Run();
                }
                else
                {
                    throw new Exception("Not found subcommand.");
                }
            }
            else
            {
                return;
            }
#if !DEBUG
            }
            catch (Exception exception)
            {
                Console.Error.WriteLine("エラー: {0}", exception.Message);
                Console.Error.WriteLine("{0}", exception.StackTrace);
                Environment.Exit(1);
            }
#endif
        }
    }
}
