﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace ContentsUploader.Models
{
    public static class Smt
    {
        [DataContract]
        public class PriceInfo
        {
            [DataContract]
            public class OnlinePrice
            {
                [DataMember(Name = "dataSource", Order = 0)]
                public string dataSource { get; set; }

#if false
                [DataMember(Name = "priceType", Order = 1)]
                public string priceType { get; set; }
#endif

                [DataMember(EmitDefaultValue = false, Name = "changeSetId", Order = 2)]
                public string changeSetId { get; set; }

                [DataMember(Name = "nsUid", Order = 3)]
                public string nsUid { get; set; }

                [DataMember(EmitDefaultValue = false, Name = "approveStatus", Order = 4)]
                public string approveStatus { get; set; }

                [DataMember(EmitDefaultValue = false, Name = "approveDate", Order = 5)]
                public string approveDate { get; set; }

                [DataContract]
                public class Price
                {
                    [DataMember(EmitDefaultValue = false, Name = "priceId", Order = 0)]
                    public string priceId { get; set; }

                    [DataMember(Name = "startDatetime", Order = 1)]
                    public string startDatetime { get; set; }

                    [DataMember(Name = "endDatetime", Order = 2)]
                    public string endDatetime { get; set; }

                    [DataMember(Name = "countryCode", Order = 3)]
                    public string countryCode { get; set; }

                    [DataMember(Name = "amount", Order = 4)]
                    public string amount { get; set; }

                    [DataMember(Name = "registeredBmsFlag", Order = 5)]
                    public string registeredBmsFlag { get; set; }

                    [DataMember(Name = "preOrderFlag", Order = 6)]
                    public string preOrderFlag { get; set; }

                    [DataMember(Name = "deferredFlag", Order = 7)]
                    public string deferredFlag { get; set; }

                    [DataContract]
                    public class TaxCategory
                    {
                        [DataMember(Name = "categoryId", Order = 0)]
                        public string categoryId { get; set; }

                        [DataMember(Name = "transactionTypeId", Order = 1)]
                        public string transactionTypeId { get; set; }
                    }
                    [DataMember(Name = "taxCategory", Order = 8)]
                    public TaxCategory taxCategory { get; set; }

                    [DataContract]
                    public class AppReleaseControls
                    {
                        [DataMember(Name = "autoSetFlag", Order = 0)]
                        public string autoSetFlag { get; set; }

                        [DataMember(Name = "releaseDatetime", Order = 1)]
                        public string releaseDatetime { get; set; }
                    }
                    [DataMember(Name = "appReleaseControls", Order = 9)]
                    public AppReleaseControls appReleaseControls { get; set; }

                    [DataContract]
                    public class PrivilegeCode
                    {
                        [DataMember(Name = "privilegeId", Order = 0)]
                        public string privilegeId { get; set; }
                    }
                    [DataMember(EmitDefaultValue = false, Name = "privilegeCodes", Order = 10)]
                    public List<PrivilegeCode> privilegeCodes { get; set; }

                    [DataContract]
                    public class PrivilegeGrant
                    {
                        [DataMember(Name = "privilegeGrantId", Order = 0)]
                        public string privilegeGrantId { get; set; }
                    }
                    [DataMember(EmitDefaultValue = false, Name = "privilegeGrants", Order = 11)]
                    public List<PrivilegeGrant> privilegeGrants { get; set; }
                }
                [DataMember(Name = "prices", Order = 6)]
                public List<Price> prices { get; set; }

                [DataContract]
                public class Ecard
                {
                    [DataMember(EmitDefaultValue = false, Name = "priceId", Order = 1)]
                    public string priceId { get; set; }

                    [DataMember(Name = "startDatetime", Order = 2)]
                    public string startDatetime { get; set; }

                    [DataMember(Name = "endDatetime", Order = 3)]
                    public string endDatetime { get; set; }

                    [DataMember(Name = "countryCode", Order = 4)]
                    public string countryCode { get; set; }

                    [DataMember(Name = "cardTypeCode", Order = 0)]
                    public string cardTypeCode { get; set; }

                    [DataMember(Name = "noPointFlag", Order = 5)]
                    public string noPointFlag { get; set; }

                    [DataMember(Name = "statExclusionFlag", Order = 6)]
                    public string statExclusionFlag { get; set; }

                    [DataMember(Name = "preOrderFlag", Order = 7)]
                    public string preOrderFlag { get; set; }

                    [DataMember(Name = "deferredFlag", Order = 8)]
                    public string deferredFlag { get; set; }

                    [DataContract]
                    public class TaxCategory
                    {
                        [DataMember(Name = "categoryId", Order = 0)]
                        public string categoryId { get; set; }

                        [DataMember(Name = "transactionTypeId", Order = 1)]
                        public string transactionTypeId { get; set; }
                    }
                    [DataMember(Name = "taxCategory", Order = 9)]
                    public TaxCategory taxCategory { get; set; }

                    [DataContract]
                    public class AppReleaseControls
                    {
                        [DataMember(Name = "autoSetFlag", Order = 0)]
                        public string autoSetFlag { get; set; }

                        [DataMember(Name = "releaseDatetime", Order = 1)]
                        public string releaseDatetime { get; set; }
                    }
                    [DataMember(Name = "appReleaseControls", Order = 10)]
                    public AppReleaseControls appReleaseControls { get; set; }

                    [DataContract]
                    public class PrivilegeCode
                    {
                        [DataMember(Name = "privilegeId", Order = 0)]
                        public string privilegeId { get; set; }
                    }
                    [DataMember(EmitDefaultValue = false, Name = "privilegeCodes", Order = 11)]
                    public List<PrivilegeCode> privilegeCodes { get; set; }

                    [DataContract]
                    public class PrivilegeGrant
                    {
                        [DataMember(Name = "privilegeGrantId", Order = 0)]
                        public string privilegeGrantId { get; set; }
                    }
                    [DataMember(EmitDefaultValue = false, Name = "privilegeGrants", Order = 12)]
                    public List<PrivilegeGrant> privilegeGrants { get; set; }
                }
                [DataMember(EmitDefaultValue = false, Name = "ecards", Order = 7)]
                public List<Ecard> ecards { get; set; }

                public bool IsAwaitingApproval()
                {
                    return string.Compare(approveStatus, "2") == 0;
                }
            }
            [DataMember(Name = "onlinePrices", Order = 0)]
            public List<OnlinePrice> onlinePrices { get; set; }

            public bool IsExistChangeSetId()
            {
                foreach (var onlinePrice in onlinePrices)
                {
                    if (!string.IsNullOrEmpty(onlinePrice.changeSetId))
                    {
                        return true;
                    }
                }
                return false;
            }

            public bool IsAwaitingApproval()
            {
                foreach (var onlinePrice in onlinePrices)
                {
                    if (onlinePrice.IsAwaitingApproval())
                    {
                        return true;
                    }
                }
                return false;
            }
        }
    }
}
