﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Runtime.Serialization;

namespace ContentsUploader.Models
{
    public static partial class Pms
    {
        // Aoc 登録で利用
        [DataContract]
        public class AocInfo
        {
            [DataMember(EmitDefaultValue = false, Name = "id", Order = 0)]
            public long id { get; set; }

            [DataMember(Name = "device_type", Order = 1)]
            public string deviceType { get; set; }

            [DataMember(Name = "product_class_code", Order = 2)]
            public string productClassCode { get; set; }

            [DataMember(Name = "form_code", Order = 3)]
            public string formCode { get; set; }

            [DataMember(Name = "initial_code", Order = 4)]
            public string initialCode { get; set; }

            [DataMember(Name = "item_code_offset", Order = 5)]
            public string itemCodeOffset { get; set; }

            [DataContract]
            public class Rating
            {
                [DataMember(Name = "system", Order = 0)]
                public string system { get; set; }

                [DataMember(EmitDefaultValue = false, Name = "id", Order = 1)]
                public long id { get; set; }

                [DataMember(EmitDefaultValue = false, Name = "descriptors", Order = 2)]
                public List<long> descriptors { get; set; }

                [DataMember(Name = "target_countries", Order = 3)]
                public List<string> targetCountries { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "ratings", Order = 6)]
            public List<Rating> ratings { get; set; }

            [DataMember(Name = "publisher", Order = 7)]
            public string publisher { get; set; }

            [DataMember(Name = "payment_recipient", Order = 8)]
            public string paymentRecipient { get; set; }

            [DataMember(Name = "roms", Order = 9)]
            public List<string> roms { get; set; }

            [DataMember(Name = "dominant_color_default_flag", Order = 10)]
            public bool dominantColorDefaultFlag { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "dominant_colors", Order = 11)]
            public List<string> dominantColors { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "purchase_restriction_countries", Order = 12)]
            public List<string> purchaseRestrictionCountries { get; set; }

            [DataContract]
            public class Names
            {
                [DataContract]
                public class FormalName : ILanguageItem<FormalName>
                {
                    [DataMember(Name = "lang", Order = 0)]
                    public string lang { get; set; }

                    [DataMember(Name = "value", Order = 1)]
                    public string value { get; set; }
                }
                [DataMember(Name = "formal_names", Order = 0)]
                public List<FormalName> formalNames { get; set; }
            }
            [DataMember(Name = "names", Order = 13)]
            public Names names { get; set; }

            [DataContract]
            public class Explanation : ILanguageItem<Explanation>
            {
                [DataMember(Name = "lang", Order = 0)]
                public string lang { get; set; }

                [DataMember(Name = "value", Order = 1)]
                public string value { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "explanations", Order = 14)]
            public List<Explanation> explanations { get; set; }

            [DataContract]
            public class CatchCopie : ILanguageItem<CatchCopie>
            {
                [DataMember(Name = "lang", Order = 0)]
                public string lang { get; set; }

                [DataMember(Name = "value", Order = 1)]
                public string value { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "catch_copies", Order = 15)]
            public List<CatchCopie> catchCopies { get; set; }

            [DataContract]
            public class Copyright : ILanguageItem<Copyright>
            {
                [DataMember(Name = "lang", Order = 0)]
                public string lang { get; set; }

                [DataMember(Name = "value", Order = 1)]
                public string value { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "copyrights", Order = 16)]
            public List<Copyright> copyrights { get; set; }

            [DataContract]
            public class Keyword : ILanguageItem<Keyword>
            {
                [DataMember(Name = "lang", Order = 0)]
                public string lang { get; set; }

                [DataMember(Name = "value", Order = 1)]
                public string value { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "keywords", Order = 17)]
            public List<Keyword> keywords { get; set; }

            [DataContract]
            public class Disclaimer : ILanguageItem<Disclaimer>
            {
                [DataMember(Name = "lang", Order = 0)]
                public string lang { get; set; }

                [DataMember(Name = "value", Order = 1)]
                public string value { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "disclaimers", Order = 18)]
            public List<Disclaimer> disclaimers { get; set; }

            [DataContract]
            public class StrongDisclaimer
            {
                [DataMember(Name = "lang", Order = 0)]
                public string lang { get; set; }

                [DataMember(Name = "value", Order = 1)]
                public string value { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "strong_disclaimers", Order = 19)]
            public List<StrongDisclaimer> strongDisclaimers { get; set; }

            [DataContract]
            public class Notice
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataMember(Name = "lang", Order = 1)]
                public string lang { get; set; }

                [DataContract]
                public class Item
                {
                    [DataMember(Name = "type", Order = 0)]
                    public string type { get; set; }

                    [DataMember(Name = "text", Order = 1)]
                    public string text { get; set; }

                    [DataMember(Name = "start_date", Order = 2)]
                    public long startDate { get; set; }

                    [DataMember(Name = "end_date", Order = 3)]
                    public long endDate { get; set; }
                }
                [DataMember(Name = "notices", Order = 2)]
                public List<Item> notices { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "notices", Order = 20)]
            public List<Notice> notices { get; set; }

            [DataContract]
            public class OnlineOnsaleDate
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataMember(Name = "year", Order = 1)]
                public long year { get; set; }

                [DataMember(Name = "month", Order = 2)]
                public long month { get; set; }

                [DataMember(Name = "day", Order = 3)]
                public long day { get; set; }
            }
            [DataMember(Name = "online_onsale_dates", Order = 21)]
            public List<OnlineOnsaleDate> onlineOnsaleDates { get; set; }

            [DataContract]
            public class Images
            {
                [DataContract]
                public class HeroBanner
                {
                    [DataMember(Name = "country", Order = 0)]
                    public string country { get; set; }

                    [DataMember(Name = "lang", Order = 1)]
                    public string lang { get; set; }

                    [DataMember(Name = "url", Order = 2)]
                    public string url { get; set; }
                }
                [DataMember(Name = "hero_banners", Order = 0)]
                public List<HeroBanner> heroBanners { get; set; }

                [DataContract]
                public class Screenshot
                {
                    [DataMember(Name = "country", Order = 0)]
                    public string country { get; set; }

                    [DataMember(Name = "lang", Order = 1)]
                    public string lang { get; set; }

                    [DataMember(Name = "urls", Order = 2)]
                    public List<string> urls { get; set; }
                }
                [DataMember(Name = "screenshots", Order = 1)]
                public List<Screenshot> screenshots { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "images", Order = 22)]
            public Images images { get; set; }

            [DataContract]
            public class Movie
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataMember(Name = "lang", Order = 1)]
                public string lang { get; set; }

                [DataContract]
                public class Item
                {
                    [DataMember(Name = "display_flag", Order = 0)]
                    public bool displayFlag { get; set; }

                    [DataMember(Name = "type", Order = 1)]
                    public string type { get; set; }

                    [DataMember(Name = "url", Order = 2)]
                    public string url { get; set; }

                    [DataMember(Name = "start_datetime", Order = 3)]
                    public long startDatetime { get; set; }

                    [DataMember(Name = "end_datetime", Order = 4)]
                    public long endDatetime { get; set; }
                }
                [DataMember(Name = "movies", Order = 2)]
                public List<Item> movies { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "movies", Order = 23)]
            public List<Movie> movies { get; set; }

            [DataContract]
            public class ReleaseControl
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataMember(Name = "public_status", Order = 1)]
                public string publicStatus { get; set; }

                [DataMember(Name = "release_datetime", Order = 2)]
                public long releaseDatetime { get; set; }
            }
            [DataMember(Name = "release_controls", Order = 24)]
            public List<ReleaseControl> releaseControls { get; set; }

            [DataContract]
            public class SalesControls
            {
                [DataMember(Name = "off_device_sales_countries", Order = 0)]
                public List<string> offDeviceSalesCountries { get; set; }

                [DataMember(Name = "on_device_sales_countries", Order = 1)]
                public List<string> onDeviceSalesCountries { get; set; }

                [DataContract]
                public class ExpectedOnlinePrice
                {
                    [DataMember(Name = "country", Order = 0)]
                    public string country { get; set; }

                    [DataMember(Name = "price", Order = 1)]
                    public long price { get; set; }
                }
                [DataMember(EmitDefaultValue = false, Name = "expected_online_prices", Order = 2)]
                public List<ExpectedOnlinePrice> expectedOnlinePrices { get; set; }
            }
            [DataMember(Name = "sales_controls", Order = 25)]
            public SalesControls salesControls { get; set; }

            [DataContract]
            public class BusinessType
            {
                [DataMember(Name = "country", Order = 0)]
                public string country { get; set; }

                [DataContract]
                public class Item
                {
                    [DataMember(Name = "start_datetime", Order = 0)]
                    public long startDatetime { get; set; }

                    [DataMember(Name = "end_datetime", Order = 1)]
                    public long endDatetime { get; set; }

                    [DataMember(Name = "code", Order = 2)]
                    public string code { get; set; }
                }
                [DataMember(Name = "business_types", Order = 1)]
                public List<Item> businessTypes { get; set; }
            }
            [DataMember(EmitDefaultValue = false, Name = "business_types", Order = 26)]
            public List<BusinessType> businessTypes { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "status", Order = 27)]
            public string status { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "last_update_datetime", Order = 28)]
            public long lastUpdateDatetime { get; set; }

            [DataMember(EmitDefaultValue = false, Name = "scheduled_reflect_datetimes", Order = 29)]
            public List<long> scheduledReflectDatetimes { get; set; }

            // 不足している言語の名称を作成
            public void BuildNames(Languages languages)
            {
                if (names == null)
                {
                    names = new Names();
                }
                names.formalNames = BuildLanguageItems<Names.FormalName>(names.formalNames, languages);
            }

            // 不足している言語の名称を作成、指定方法で名称を変更
            public void UpdateNames(Languages languages, Func<string, string> naming, bool isNameChanged, bool isLaguageChanged)
            {
                if (names == null)
                {
                    names = new Names();
                }
                names.formalNames = BuildLanguageItems<Names.FormalName>(names.formalNames, languages);
                UpdateLanguageItems<Names.FormalName>(names.formalNames, languages, naming, isNameChanged, isLaguageChanged);
            }
        }
    }
}
