﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Nintendo.Foundation.IO;
using ContentsUploader.Assistants;

namespace ContentsUploader.Commands
{
    public class RevokeRomCommand : CommandBase
    {
        [CommandLineOption("application-id", DefaultValue = "", Description = "input application id")]
        public override string ApplicationIdOption { get; set; }

        [CommandLineOption("rom-id", DefaultValue = "", Description = "input rom id")]
        public override string RomIdOption { get; set; }

        [CommandLineOption('t', "token", DefaultValue = "", Description = "CLI Token")]
        public override string TokenOption { get; set; }

        [CommandLineOption('u', "user", DefaultValue = "", Description = "Login ID of CLI Token")]
        public override string UserOption { get; set; }

        [CommandLineOption('p', "password", DefaultValue = "", Description = "Password of CLI Token")]
        public override string PasswordOption { get; set; }

        public override void Run()
        {
            Run("Revoke Rom", Mode.IsTokenRequired);
        }

        protected override bool RunByApplicationId(Id64 applicationId)
        {
            var d4c = new D4cHelper(Setting.Current);
            return d4c.RevokeApplicationId(applicationId);
        }

        protected override bool RunByRomId(string romId)
        {
            var d4c = new D4cHelper(Setting.Current);
            return d4c.RevokeRomId(romId);
        }
    }
}
