﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using Nintendo.Foundation.IO;
using ContentsUploader.Assistants;

namespace ContentsUploader.Commands
{
    public class ListRomIdCommand : CommandBase
    {
        [CommandLineOption("application-id", DefaultValue = "", Description = "input application id")]
        public override string ApplicationIdOption { get; set; }

        [CommandLineOption("content-meta-id", DefaultValue = "", Description = "input content meta id")]
        public override string ContentMetaIdOption { get; set; }

        [CommandLineOption("rom-id", DefaultValue = "", IsHidden = true, Description = "input rom id")]
        public override string RomIdOption { get; set; }

        [CommandLineOption("status", DefaultValue = "", Description = "status type filter")]
        public string StatusOption { get; set; }

        public override void Run()
        {
            Run("List RomId");
        }

        protected override bool RunByContentMetaId(Id64 contentMetaId)
        {
            var d4c = new D4cHelper(Setting.Current);
            var output = string.Empty;
            d4c.ListRomIdByContentMetaId(out output, contentMetaId, 0, StatusOption);
            Log.WriteLineAsIs(ToolUtility.FormatIndentedJson(output));
            return true;
        }

        protected override bool RunByApplicationId(Id64 applicationId)
        {
            var d4c = new D4cHelper(Setting.Current);
            var output = string.Empty;
            d4c.ListRomIdByApplicationId(out output, applicationId, 0, 30, StatusOption);
            Log.WriteLineAsIs(ToolUtility.FormatIndentedJson(output));
            return true;
        }

        protected override bool RunByRomId(string romId)
        {
            var d4c = new D4cHelper(Setting.Current);
            var output = string.Empty;
            d4c.ListRomIdDetail(out output, romId);
            Log.WriteLineAsIs(ToolUtility.FormatIndentedJson(output));
            d4c.ListRomIdToTitleId(out output, romId);
            Log.WriteLineAsIs(ToolUtility.FormatIndentedJson(output));
            return true;
        }
    }
}
