﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CommandUtility
{
    public class Singleton<TargetType> where TargetType : class, new()
    {
        private static volatile TargetType instance;
        private static object syncRoot = new object();

        public static TargetType Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (syncRoot)
                    {
                        if (instance == null)
                        {
                            instance = new TargetType();
                        }
                    }
                }

                return instance;
            }
        }
    }
}
