﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary.Elf64
{
    using System;
    using System.IO;
    using ElfLibrary;

    /// <summary>
    /// ELF 64bit セクションヘッダクラス
    /// </summary>
    public class Elf64SectionHeader : ElfSectionHeader
    {
        /// <summary>
        /// ELF セクションヘッダのサイズ
        /// </summary>
        public const ushort Elf64HeaderSize = 64;

        /// <summary>
        /// ファイルから SectionHeader を読み込みます。
        /// </summary>
        /// <param name="reader">読み込みインスタンス</param>
        public override void ReadElfFile(ElfBinaryReader reader)
        {
            Name = reader.ReadUInt32();
            Type = reader.ReadUInt32();
            Flags = reader.ReadUInt64();
            Address = reader.ReadUInt64();
            Offset = reader.ReadUInt64();
            Size = reader.ReadUInt64();
            Link = reader.ReadUInt32();
            Info = reader.ReadUInt32();
            AddressAlign = reader.ReadUInt64();
            EntrySize = reader.ReadUInt64();
        }

        /// <summary>
        /// ファイルに SectionHeader を書き込みます。
        /// </summary>
        /// <param name="writer">書き込みインスタンス</param>
        public override void WriteElfData(ElfBinaryWriter writer)
        {
            writer.WriteUInt32(Name);
            writer.WriteUInt32(Type);
            writer.WriteUInt64(Flags);
            writer.WriteUInt64(Address);
            writer.WriteUInt64(Offset);
            writer.WriteUInt64(Size);
            writer.WriteUInt32(Link);
            writer.WriteUInt32(Info);
            writer.WriteUInt64(AddressAlign);
            writer.WriteUInt64(EntrySize);
        }
    }
}
