﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace ElfLibrary.Elf64
{
    using System;

    /// <summary>
    /// Elf 64-bit DynamicSection クラス
    /// </summary>
    public class Elf64DynamicSection : ElfDynamicSection
    {
        public const ushort Elf64HeaderSize = 16;

        /// <summary>
        /// ファイルから Dynamic Section を読み込みます。
        /// </summary>
        /// <param name="reader">読み込みインスタンス</param>
        public override void ReadElfFile(ElfBinaryReader reader)
        {
            D_Tag = checked((long)reader.ReadUInt64());
            D_Un = reader.ReadUInt64();
        }

        /// <summary>
        /// ファイルに Dynamic Section を書き込みます。
        /// </summary>
        /// <param name="writer">書き込みインスタンス</param>
        public override void WriteElfData(ElfBinaryWriter writer)
        {
            writer.WriteUInt64(checked((ulong)D_Tag));
            writer.WriteUInt64(D_Un);
        }
    }
}
