﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Bin2Obj
{
    using System;
    using System.IO;
    using ElfLibrary;

    public class Program
    {
        public static void Main(string[] args)
        {
            Bin2ObjArgs opt = new Bin2ObjArgs();
            try
            {
                if (!opt.ParseArgs(args))
                {
                    return;
                }
            }
            catch
            {
                Environment.ExitCode = 1;
                return;
            }

            Bin2ObjParams param = opt.Params;

            try
            {
                ElfObject obj = GenerateElfObject(param.Machine, param.Endian, param.Architecture);

                ElfDataSectionParameter dataSection = new ElfDataSectionParameter(
                    binaryFileName: param.BinaryFileName,
                    isWritable: param.Writable,
                    sectionRwData: param.SectionRwData,
                    sectionRoData: param.SectionRoData,
                    symbolBegin: param.SymbolBegin,
                    symbolEnd: param.SymbolEnd,
                    align: param.Align);

                using (FileStream dataFile = new FileStream(param.BinaryFileName, FileMode.Open, FileAccess.Read))
                {
                    dataSection.ReadDataSection(dataFile);
                    dataFile.Close();
                    obj.AddDataSection(dataSection);
                }

                obj.MapSection();

                using (FileStream fs = new FileStream(param.ObjectFileName, FileMode.Create, FileAccess.Write))
                {
                    obj.OutputObject(fs);
                }
            }
            catch (Exception e)
            {
                Console.Error.WriteLine("ELFオブジェクトの生成に失敗しました。");
                Console.Error.WriteLine(e.Message);
                Environment.ExitCode = 1;
                return;
            }
        }

        public static ElfObject GenerateElfObject(ushort machine, byte byteOrder, byte architecture)
        {
            if (NumericConvert.IntToElfDefine<ElfMachineType>(machine) == ElfMachineType.Unknown)
            {
                throw new ArgumentException();
            }
            return new ElfObject(
                NumericConvert.IntToElfDefine<ElfMachineType>(machine),
                NumericConvert.IntToElfDefine<ElfByteOrderType>(byteOrder),
                NumericConvert.IntToElfDefine<ElfArchitectureType>(architecture));
        }
    }
}
