﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "../Util/DeclareAlive.h"
#include "ManagedStreamStorage.h"
#include "StorageArchiveReader.h"
#include "StorageArchiveReaderImplBase.h"

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;
using namespace System::IO;
using namespace System::Collections;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;

using namespace nn;

    private class StorageArchiveReaderImpl : public StorageArchiveReaderImplBase
    {
    public:
        explicit StorageArchiveReaderImpl(std::shared_ptr<fs::IStorage> storage)
            : StorageArchiveReaderImplBase(storage.get())
            , m_StorageHolder(std::move(storage))
        {
        }

        StorageArchiveReaderImpl(fs::IStorage* pStorage, std::shared_ptr<fs::IStorage> storageHolder)
            : StorageArchiveReaderImplBase(pStorage)
            , m_StorageHolder(std::move(storageHolder))
        {
        }

    private:
        std::shared_ptr<fs::IStorage> m_StorageHolder;
    };

    StorageArchiveReader::StorageArchiveReader(Stream^ stream)
    {
        auto storage = std::shared_ptr<fs::IStorage>(new ManagedStreamStorage(stream));
        m_Impl = new StorageArchiveReaderImpl(std::move(storage));
        GC::KeepAlive(this);
    }

    StorageArchiveReader::StorageArchiveReader(std::shared_ptr<fs::IStorage> storage)
    {
        m_Impl = new StorageArchiveReaderImpl(std::move(storage));
        GC::KeepAlive(this);
    }

    StorageArchiveReader::StorageArchiveReader(fs::IStorage* pStorage, std::shared_ptr<fs::IStorage> storageHolder)
    {
        m_Impl = new StorageArchiveReaderImpl(pStorage, std::move(storageHolder));
        GC::KeepAlive(this);
    }

    StorageArchiveReader::~StorageArchiveReader()
    {
        this->!StorageArchiveReader();
    }

    StorageArchiveReader::!StorageArchiveReader()
    {
        delete m_Impl;
    }

    array<byte>^ StorageArchiveReader::Read(Int64 offset, Int32 size)
    {
        return Util::ReturnAndDeclareAlive(this, m_Impl->Read(offset, size));
    }

    int64_t StorageArchiveReader::GetSize()
    {
        return Util::ReturnAndDeclareAlive(this, m_Impl->GetSize());
    }

}}}
