﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_IStorage.h>
#include "IndirectStorageStreamUtil.h"

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;
using namespace System::IO;

class RelocatedIndirectStorageStreamImpl;
class AesCtrExGenerationTable;

public ref class RelocatedIndirectStorageStream
{
public:
    RelocatedIndirectStorageStream(
        array<Byte>^ oldFsHeader, int64_t oldFsStartOffset,
        IReadOnlySource^ oldSource,
        IReadOnlySource^ oldAesCtrExTableSource,
        array<Byte>^ newFsHeader, int64_t newFsStartOffset,
        IReadOnlySource^ newSource,
        int64_t outputFsStartOffset);
    ~RelocatedIndirectStorageStream();
    !RelocatedIndirectStorageStream();

    void SetBinaryRegionInfo(String^ originalPath, String^ outputPath, array<Byte>^ rawHeader);
    void Build(UInt32 shiftSize, UInt32 blockSize, UInt32 regionSize, Int64 matchSize, UInt32 generationForUpdatedRegion);
    IndirectStorageProgress GetProgress(); // Build の進捗を取得

    void WriteIndirectTable(array<Byte>^ headerBuffer, array<Byte>^ tableBuffer);
    void WriteAesCtrExTable(array<Byte>^ headerBuffer, array<Byte>^ tableBuffer);
    void VerifyAesCtrExTable(array<Byte>^ headerBuffer, array<Byte>^ tableBuffer, UInt32 generationForUpdatedRegion);

    array<Byte>^ ReadData(Int64 offset, Int32 size);

    void OutputBuildLog(Stream^ tableStream, Stream^ fragmentStream, Stream^ encryptionStream, Int64 startOffset);

    Int32 GetIndirectHeaderSize();
    Int32 GetIndirectTableSize();
    Int64 GetIndirectTableOffset();

    Int32 GetAesCtrExHeaderSize();
    Int32 GetAesCtrExTableSize();
    Int64 GetAesCtrExTableOffset();

    Int64 GetDataSize();

private:
    RelocatedIndirectStorageStreamImpl* m_pImpl;
};

}}}
