﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <msclr/marshal.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs/fs_Result.h>
#include <nn/fs/fs_IStorage.h>

namespace Nintendo { namespace Authoring { namespace FileSystemMetaLibrary {

using namespace System;
using namespace System::IO;
using namespace System::Collections;
using namespace System::Collections::Generic;
using namespace System::Runtime::InteropServices;

using namespace nn;

    private class ManagedByteArrayStorage : public fs::IStorage
    {
    public:
        explicit ManagedByteArrayStorage(array<Byte>^ byteArray) : m_ByteArray(byteArray) {}
        virtual ~ManagedByteArrayStorage() NN_NOEXCEPT {}

        virtual Result Read(int64_t offset, void* buffer, size_t size)
        {
            try
            {
                Marshal::Copy(m_ByteArray, static_cast<int>(offset), static_cast<IntPtr>(buffer), static_cast<int>(size));
            }
            catch (Exception^ ex)
            {
                throw ex;
            }

            NN_RESULT_SUCCESS;
        }

        virtual Result Write(int64_t offset, const void* buffer, size_t size)
        {
            try
            {
                void* ptr = const_cast<void*>(buffer);
                Marshal::Copy(static_cast<IntPtr>(ptr), m_ByteArray, static_cast<int>(offset), static_cast<int>(size));
            }
            catch (Exception^ ex)
            {
                throw ex;
            }

            NN_RESULT_SUCCESS;
        }

        virtual Result Flush() NN_NOEXCEPT
        {
            NN_RESULT_SUCCESS;
        }

        virtual nn::Result GetSize(int64_t* outValue) NN_NOEXCEPT
        {
            *outValue = m_ByteArray->Length;
            NN_RESULT_SUCCESS;
        }

    private:
        gcroot<array<Byte>^> m_ByteArray;
    };

}}}
