﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace Nintendo { namespace Authoring { namespace CryptoLibrary {

using namespace System;

    public enum class Rsa2048PssSha256KeyIndex : uint8_t
    {
        NcaHeader1,
        Acid,
        NrrCertificate,
    };

    public enum class Rsa2048Pkcs1Sha256KeyIndex : uint8_t
    {
        XciHeader,
        ETicket,
    };

    public interface class ISigner
    {
    public:
        array<Byte>^ SignBlock(array<Byte>^ src, int srcOffset, int srcSize);
        bool VerifyBlock(array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ signature);
        array<Byte>^ GetKeyModulus();
        array<Byte>^ GetKeyPublicExponent();
    };

}}}
