﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/crypto/crypto_AesEncryptor.h>
#include <nn/crypto/crypto_AesDecryptor.h>
#include "HsmInterfaceManager.h"
#include "IEncryptor.h"

namespace Nintendo { namespace Authoring { namespace CryptoLibrary {

using namespace System;
using namespace System::Security::Cryptography;

    public ref class Aes128CryptoDriver : IEncryptor
    {
    public:
        property int KeySize
        {
            virtual int get() { return 16; }
        };

        Aes128CryptoDriver(array<Byte>^ key)
        {
            m_Cryptor = gcnew AesCryptoServiceProvider();
            m_Cryptor->BlockSize = KeySize * 8; // bit
            m_Cryptor->KeySize = KeySize * 8; // bit
            m_Cryptor->Mode = CipherMode::ECB;
            m_Cryptor->Padding = PaddingMode::None;
            m_Cryptor->Key = key;
            GC::KeepAlive(this);
        }

        Aes128CryptoDriver(Aes128KeyIndex keyIndex)
        {
            GC::KeepAlive(this);
            throw gcnew NotImplementedException();
        }

        ~Aes128CryptoDriver()
        {
            this->!Aes128CryptoDriver();
        }

        !Aes128CryptoDriver()
        {
        }

        virtual void EncryptBlock(array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset)
        {
            auto encrypt = m_Cryptor->CreateEncryptor();
            encrypt->TransformBlock(src, srcOffset, srcSize, dst, dstOffset);
            encrypt = nullptr; // Dispose
            GC::KeepAlive(this);
        }

        virtual void DecryptBlock(array<Byte>^ src, int srcOffset, int srcSize, array<Byte>^ dst, int dstOffset)
        {
            auto decrypt = m_Cryptor->CreateDecryptor();
            decrypt->TransformBlock(src, srcOffset, srcSize, dst, dstOffset);
            decrypt = nullptr; // Dispose
            GC::KeepAlive(this);
        }

    private:
        AesCryptoServiceProvider^ m_Cryptor;
    };

}}}
