﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace Nintendo.Authoring.AuthoringLibrary
{
    public interface ISink
    {
        long Size { get; }
        /// <summary>
        /// ISink に指定したデータを指定したオフセットから書き込み、実際に書き込めた分のサイズを返します。
        /// </summary>
        int PushData(ByteData data, long offset);
        SinkStatus QueryStatus(); // Todo: long offset 引数
        void SetSize(long size);
    }

    public interface IReadableSink : ISink
    {
        ISource ToSource();
    }
}
