﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace AOCommonLibrary
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// コマンドライン引数をパースするクラスです。
    /// </summary>
    public class Parser
    {
        /// <summary>
        /// コマンドライン引数をパスします
        /// </summary>
        /// <param name="args">コマンドライン引数</param>
        /// <returns>パース結果</returns>
        public static Dictionary<string, string> ParseCommandLineArgs(string[] args)
        {
            // コマンドラインオプションをHashSetに格納する
            var options = new HashSet<string> { "-c", "-i", "-o", "-w" };

            try
            {
                string key = null;

                // コマンドラインオプションの解析
                return args.GroupBy(s => options.Contains(s) ? key = s : key)
                    .ToDictionary(g => g.Key, g => g.Skip(1).FirstOrDefault()); // 1番目はキーなので Skip
            }
            catch (Exception ex)
            {
                Console.Error.WriteLine("ERROR: " + ex.Message);
                Console.Error.WriteLine("Usage : xxx.exe [-c] [-i <input>] [-o <output>] [-w <time>]\n");
                Console.Error.WriteLine("-c");
                Console.Error.WriteLine("    出力ファイルに書き込むコピーライトの文言を LGPL 用のものに変更します。\n");
                Console.Error.WriteLine("-i");
                Console.Error.WriteLine("    入力ファイルを指定します。省略した場合は標準入力が指定されます。\n");
                Console.Error.WriteLine("-o");
                Console.Error.WriteLine("    出力ファイルを指定します。省略した場合は標準出力が指定されます。\n");
                Console.Error.WriteLine("-w");
                Console.Error.WriteLine("    標準入力から読み込む前のスリープ時間をミリ秒で指定します。デフォルトは 200 ms です。\n");
                Environment.Exit(1);
                throw;
            }
        }
    }
}
