﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_TimeSpan.h>
#include <nn/os/os_Thread.h>
#include <nn/result/result_HandlingUtility.h>

#include "systemInitializer_I2cHelper.h"
#include "systemInitializer_RtcDriver.h"

namespace nn { namespace systemInitializer {

nn::Result RtcDriver::GetRtcInt(uint8_t* pOut) NN_NOEXCEPT
{
    const uint8_t address = 0x00;
    NN_RESULT_DO(ReadI2cRegister(pOut, m_I2cSession, &address, sizeof(address), sizeof(*pOut)));
    NN_RESULT_SUCCESS;
}

nn::Result RtcDriver::GetRtcIntM(uint8_t* pOut) NN_NOEXCEPT
{
    const uint8_t address = 0x01;
    NN_RESULT_DO(ReadDoubleBufferedRegister(pOut, address));
    NN_RESULT_SUCCESS;
}

nn::Result RtcDriver::MaskRtcAlarm() NN_NOEXCEPT
{
    const uint8_t address = 0x01;
    const uint8_t mask = 0x3F;
    NN_RESULT_DO(WriteDoubleBufferedRegister(address, mask));
    NN_RESULT_SUCCESS;
}

nn::Result RtcDriver::ReadDoubleBufferedRegister(uint8_t* pOut, uint8_t address) NN_NOEXCEPT
{
    const uint8_t update0Address = 0x04;
    const uint8_t update0Data = 0x10;
    NN_RESULT_DO(WriteI2cRegister(m_I2cSession, &update0Address, sizeof(update0Address), &update0Data, sizeof(update0Data)));
    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(16));
    NN_RESULT_DO(ReadI2cRegister(pOut, m_I2cSession, &address, sizeof(address), sizeof(*pOut)));
    NN_RESULT_SUCCESS;
}

nn::Result RtcDriver::WriteDoubleBufferedRegister(uint8_t address, uint8_t value) NN_NOEXCEPT
{
    const uint8_t update0Address = 0x04;
    const uint8_t update0Data = 0x01;
    NN_RESULT_DO(WriteI2cRegister(m_I2cSession, &address, sizeof(address), &value, sizeof(value)));
    NN_RESULT_DO(WriteI2cRegister(m_I2cSession, &update0Address, sizeof(update0Address), &update0Data, sizeof(update0Data)));
    nn::os::SleepThread(nn::TimeSpan::FromMilliSeconds(16));
    NN_RESULT_SUCCESS;
}

}} // namespace nn::boot
