﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/nn_TimeSpan.h>
#include <nn/nn_SdkLog.h>
#include <nn/os/os_Thread.h>
#include <nn/result/result_HandlingUtility.h>

#include "systemInitializer_I2cHelper.h"
#include "systemInitializer_PmicDriver.h"

NN_NORETURN void PmicDriver::ShutdownSystem() NN_NOEXCEPT
{
    NN_SDK_LOG("[boot] Shutdown System.\n");
    ShutdownSystem(false);
}

NN_NORETURN void PmicDriver::RebootSystem() NN_NOEXCEPT
{
    NN_SDK_LOG("[boot] Reboot System.\n");
    ShutdownSystem(true);
}

NN_NORETURN void PmicDriver::ShutdownSystem(bool isReboot) NN_NOEXCEPT
{
    const uint8_t onoffcnfg1Address = 0x41;
    const uint8_t onoffcnfg2Address = 0x42;
    const uint8_t sftRstMask = 0x80;
    const uint8_t sftRstWkMask = 0x80;
    const auto shutdownTimeout = nn::TimeSpan::FromMilliSeconds(5000);

    uint8_t onoffcnfg2Value = 0x00;
    NN_ABORT_UNLESS_RESULT_SUCCESS(ReadI2cRegister(&onoffcnfg2Value, m_I2cSession, &onoffcnfg2Address, sizeof(onoffcnfg2Address), sizeof(onoffcnfg2Value)));
    if (isReboot)
    {
        onoffcnfg2Value = onoffcnfg2Value | sftRstWkMask;
    }
    else
    {
        onoffcnfg2Value = onoffcnfg2Value & (~sftRstWkMask);
    }
    NN_ABORT_UNLESS_RESULT_SUCCESS(WriteI2cRegister(m_I2cSession, &onoffcnfg2Address, sizeof(onoffcnfg2Address), &onoffcnfg2Value, sizeof(onoffcnfg2Value)));

    uint8_t onoffcnfg1Value = 0x00;
    NN_ABORT_UNLESS_RESULT_SUCCESS(ReadI2cRegister(&onoffcnfg1Value, m_I2cSession, &onoffcnfg1Address, sizeof(onoffcnfg1Address), sizeof(onoffcnfg1Value)));
    onoffcnfg1Value = onoffcnfg1Value | sftRstMask;

    // nn::bpc::driver::detail::ShutdownSystemImpl ではここで RTC Alarm 2 をセットしているが、boot ライブラリではシャットダウンを給電状態で行うことがないため、不要

    NN_ABORT_UNLESS_RESULT_SUCCESS(WriteI2cRegister(m_I2cSession, &onoffcnfg1Address, sizeof(onoffcnfg1Address), &onoffcnfg1Value, sizeof(onoffcnfg1Value)));

    nn::os::SleepThread(shutdownTimeout);
    NN_ABORT("[boot] Timeout of shutdown signal.");
}
