﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <string>
#include <memory>
#include <nn/nn_Result.h>
#include <nn/fs/fs_Bis.h>
#include <nn/fs/fs_IStorage.h>

class IFile;

nn::Result ExportPartition(std::string outputPath, std::string type, std::string name, int64_t size, int64_t beginAddress);
nn::Result ExportPartition(IFile *pOut, nn::fs::IStorage *pSource, int64_t size, int64_t beginAddress);
nn::Result OpenBlockStorage(std::unique_ptr<nn::fs::IStorage> *pOut, std::string type, std::string name);
nn::Result OpenBlockStorage(std::unique_ptr<nn::fs::IStorage> *pOut, nn::fs::BisPartitionId partitionId);
nn::Result OpenGptHeader(std::unique_ptr<nn::fs::IStorage> *pOut);
nn::Result OpenGptPartitionTable(std::unique_ptr<nn::fs::IStorage> *pOut);
nn::Result OpenGptPartition(std::unique_ptr<nn::fs::IStorage> *pOut, std::string name);
