﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/sf/sf_HipcServer.h>

#include <nn/spl/spl_Api.h>
#include "spl_DeviceUniqueDataServer.h"

namespace nn { namespace spl {

    class ManuServer : public DeviceUniqueDataServer
    {
    public:
        explicit ManuServer(SecureMonitorManager* p)
            : DeviceUniqueDataServer(p)
        {
        }

        nn::Result ReencryptDeviceUniqueData(
            const nn::sf::OutArray<nn::Bit8>& result,
            const nn::sf::InArray<nn::Bit8>& data,
            const nn::spl::AccessKey& accessKeyForDecryption,
            const nn::spl::detail::KeySource& keySourceForDecryption,
            const nn::spl::AccessKey& accessKeyForEncryption,
            const nn::spl::detail::KeySource& keySourceForEncryption,
            nn::Bit32 option) NN_NOEXCEPT
        {
            return m_Manager.ReencryptDeviceUniqueData(
                result.GetData(),
                result.GetLength(),
                data.GetData(),
                data.GetLength(),
                accessKeyForDecryption,
                &keySourceForDecryption,
                sizeof(keySourceForDecryption),
                accessKeyForEncryption,
                &keySourceForEncryption,
                sizeof(keySourceForEncryption),
                option );
        }
    };

}}  // namespace nn::spl
