﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/sf/sf_HipcServer.h>

#include <nn/spl/spl_Api.h>
#include "spl_CryptoServer.h"

namespace nn { namespace spl {

    class FsServer : public CryptoServer
    {
    public:
        explicit FsServer(SecureMonitorManager* p)
            : CryptoServer(p)
        {
        }

        nn::Result DecryptAndStoreGcKey(
            const nn::sf::InArray<nn::Bit8>& data,
            const nn::spl::AccessKey& accessKey,
            const nn::spl::detail::KeySource& keySource) NN_NOEXCEPT
        {
            return m_Manager.DecryptAndStoreGcKey(
                data.GetData(),
                data.GetLength(),
                accessKey,
                &keySource,
                sizeof(keySource) );
        }

        nn::Result DecryptGcMessage(
            nn::sf::Out<int> outResultSize,
            const nn::sf::OutArray<nn::Bit8>& result,
            const nn::sf::InArray<nn::Bit8>& cipher,
            const nn::sf::InArray<nn::Bit8>& modulus,
            const nn::sf::InArray<nn::Bit8>& labelDigest) NN_NOEXCEPT
        {
            return m_Manager.DecryptGcMessage(
                &*outResultSize,
                result.GetData(),
                result.GetLength(),
                cipher.GetData(),
                cipher.GetLength(),
                modulus.GetData(),
                modulus.GetLength(),
                labelDigest.GetData(),
                labelDigest.GetLength() );
        }

        nn::Result GenerateSpecificAesKey(
            nn::sf::Out<nn::spl::detail::AesKey> key,
            const nn::spl::detail::KeySource& keySource,
            std::int32_t generation,
            nn::Bit32 purpose) NN_NOEXCEPT
        {
            return m_Manager.GenerateSpecificAesKey(
                &*key,
                sizeof(*key),
                &keySource,
                sizeof(keySource),
                generation,
                purpose );
        }

        nn::Result LoadPreparedAesKey(
            std::int32_t slotIndex,
            const nn::spl::AccessKey& accessKey) NN_NOEXCEPT
        {
            return m_Manager.LoadPreparedAesKey(
                slotIndex,
                this,
                accessKey );
        }

        nn::Result GetPackage2Hash(
            const nn::sf::OutArray<nn::Bit8>& result) NN_NOEXCEPT
        {
            return m_Manager.GetPackage2Hash(
                result.GetData(),
                result.GetLength());
        }
    };

}}  // namespace nn::spl
