﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/os/os_SdkMultipleWaitApi.h>
#include <nn/svc/svc_Base.h>

#include "pm_ProcessInfo.h"

namespace nn { namespace pm {

    nn::lmem::HeapCommonHead ProcessInfo::g_HeapHead;
    nn::lmem::HeapHandle     ProcessInfo::g_HeapHandle;


    void ProcessInfo::InitializeHeap(void* p, size_t size) NN_NOEXCEPT
    {
        g_HeapHandle = lmem::CreateUnitHeap(p, size, sizeof(ProcessInfo), 0, 8, &g_HeapHead);
    }

    void* ProcessInfo::operator new (size_t) throw()
    {
        return lmem::AllocateFromUnitHeap(g_HeapHandle);
    }
    void ProcessInfo::operator delete (void* p)
    {
        lmem::FreeToUnitHeap(g_HeapHandle, p);
    }

    ProcessInfo::ProcessInfo(
        nn::svc::Handle             handle,
        nn::os::ProcessId           processId,
        nn::ldr::PinId              pinId,
        nn::ncm::ProgramLocation    programLocation ) NN_NOEXCEPT
    : m_Handle(handle)
    , m_ProcessId(processId)
    , m_PinId(pinId)
    , m_ProgramLocation(programLocation)
    , m_State(svc::ProcessState_Initializing)
    , m_Flags(0)
    {
        os::InitializeMultiWaitHolder(&this->m_MultiWaitHolder, GetOsHandle());
        os::SetMultiWaitHolderUserData(&this->m_MultiWaitHolder, reinterpret_cast<uintptr_t>(this));
    }

    ProcessInfo::~ProcessInfo() NN_NOEXCEPT
    {
    }


}}  // namespace nn::pm

