﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include "pm_BootModeManager.h"

namespace nn { namespace pm {
    Result BootModeManager::GetBootMode(sf::Out<Bit32> outValue) NN_NOEXCEPT
    {
        *outValue = static_cast<Bit32>(m_BootMode);
        NN_RESULT_SUCCESS;
    }

    Result BootModeManager::SetMaintenanceBoot() NN_NOEXCEPT
    {
        m_BootMode = BootMode_Maintenance;
        NN_RESULT_SUCCESS;
    }
}}  // namespace nn::pm
