﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/svc/svc_Types.h>
#include <nn/os/os_Types.h>
#include <nn/ro/detail/ro_NroHeader.h>
#include <nn/ro/detail/ro_NrrHeader.h>
#include <nn/ldr/ldr_Types.h>
#include <nn/ncm/ncm_ProgramLocation.h>

namespace nn { namespace ldr {


    class RoManager
    {
    public:
        static const PinId InvalidPinId;
        static const int ProcessCount = 64;
        static const int NsoCount  = 32;

    private:
        struct NsoInfo
        {
            bool                    isUsed;
            uint64_t                moduleAddress;
            uint64_t                moduleSize;
            ro::detail::ModuleId    moduleId;
        };

        struct ProcessInfo
        {
            bool                    isUsed;
            PinId                   pinId;
            os::ProcessId           processId;
            Bit64                   programId;
            ncm::ProgramLocation    programLocation;
            NsoInfo                 nsoInfo[NsoCount];
            uintptr_t               sessionObjAddress;
        };

        ProcessInfo m_Processes[ProcessCount];
        uint64_t    m_PinId;

    public:
        bool Allocate(PinId* pOutPinId, const ncm::ProgramLocation& location) NN_NOEXCEPT;

        bool Free(PinId pinId) NN_NOEXCEPT;

        void RegisterProcess(
                PinId                           pinId,
                os::ProcessId                   processId,
                Bit64                           programId,
                bool                            is64BitAddressSpace) NN_NOEXCEPT;

        bool GetProgramLocation(ncm::ProgramLocation* outValue, PinId pinId) NN_NOEXCEPT;

        void AddNso(PinId id, const Bit8* pModuleId, uint64_t address, uint64_t size) NN_NOEXCEPT;

        bool GetProcessModuleInfo(
                int*                            pOutCount,
                ModuleInfo*                     pBuffer,
                int                             num,
                os::ProcessId                   processId) NN_NOEXCEPT;

    private:
        ProcessInfo* AllocateProcessInfo() NN_NOEXCEPT;
        ProcessInfo* FindProcessInfo(PinId pinId) NN_NOEXCEPT;
        ProcessInfo* FindProcessInfo(os::ProcessId processId) NN_NOEXCEPT;
        ProcessInfo* FindProcessInfo(Bit64 programId) NN_NOEXCEPT;

        NsoInfo* AllocateNsoInfo(ProcessInfo* pInfo) NN_NOEXCEPT;
    };

    extern RoManager            g_RoManager;
}}  // namespace nn::ldr

