﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/util/util_BitPack.h>

namespace nn { namespace ldr {

    Result TestCapability(
                const util::BitPack32*  pKcd,
                int                     kcdCount,
                const util::BitPack32*  pKc,
                int                     kcCount ) NN_NOEXCEPT;

    Bit16 MakeProgramInfoFlag(
                const util::BitPack32*  pKc,
                int                     kcCount ) NN_NOEXCEPT;

}}  // namespace nn::ldr
