﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fssystem/fs_NcaFileSystemDriver.h>
#include <nn/fssrv/fscreator/fssrv_BuiltInStorageCreator.h>
#include <nn/fssrv/fscreator/fssrv_EncryptedFileSystemCreator.h>
#include <nn/fssrv/fssrv_SaveDataTransferCryptoConfiguration.h>
#include <nn/fs/fs_SdCardPrivate.h>

const nn::fssystem::NcaCryptoConfiguration* GetNcaCryptoConfiguration(bool isProd) NN_NOEXCEPT;
nn::fssrv::SaveDataTransferCryptoConfiguration* GetSaveDataTransferCryptoConfiguration(bool isProd) NN_NOEXCEPT;
const unsigned char* GetSignedSystemPartitionSignKeyPublicModulus(bool isProd) NN_NOEXCEPT;

void GetBisEncryptionKey(nn::fssrv::fscreator::BuiltInStorageCreator::Key* pOutValueKey, int keyCount, nn::fssrv::fscreator::BisPartitionEncryptionKeyId id, int keyGeneration) NN_NOEXCEPT;
void GetSdCardEncryptionKey(nn::fssrv::fscreator::EncryptedFileSystemCreator::Key* pOutValueKey, int keyCount, nn::fssrv::fscreator::EncryptedFileSystemCreator::KeyId id, const nn::fs::EncryptionSeed& seed) NN_NOEXCEPT;

void GenerateDeviceUniqueMacForSaveData(void* macBuffer, size_t macBufferSize, const void* dataBuffer, size_t dataBufferSize) NN_NOEXCEPT;
void GenerateSeedUniqueMacForSaveData(void* macBuffer, size_t macBufferSize, const void* dataBuffer, size_t dataBufferSize, const void* seedBuffer, size_t seedBufferSize) NN_NOEXCEPT;

void GenerateRandomForSaveData(void* pData, size_t size) NN_NOEXCEPT;
void GenerateRandomForSdCardEncryption(void* pData, size_t size) NN_NOEXCEPT;

void SetUpKekAccessKeys() NN_NOEXCEPT;

void InvalidateHwAesKey() NN_NOEXCEPT;

void GenerateRandomForSaveDataTransfer(void* pData, size_t size) NN_NOEXCEPT;
void GenerateAesKeyForSaveDataTransfer(void* pBuffer, size_t bufferSize, nn::fssrv::SaveDataTransferCryptoConfiguration::KeyIndex keyIndex, const void* pKeySource, size_t keySourceSize) NN_NOEXCEPT;
