﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#include <nn/svc/svc_DdId.autogen.h>


//-------------------------------------------------
// Result CreateSharedMemory(nn::svc::Handle* pOut, size_t size, nn::svc::MemoryPermission myPermission, nn::svc::MemoryPermission otherPermission)
//
//     AArch32 s=4 r=4 p=4                  Invariant s=4 r=8 p=4
// in  abi                                  svc
//     Register 0  ref  4 pOut              
//     Register 1       4 size              Register 1       4 size
//     Register 2       4 myPermission      Register 2       4 myPermission
//     Register 3       4 otherPermission   Register 3       4 otherPermission
//
// out abi                                  svc
//     Register 0       4 return            Register 0       4 return
//                                          Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler18CreateSharedMemoryEPNS0_6HandleEjNS0_16MemoryPermissionES5_, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler18CreateSharedMemoryEPNS0_6HandleEjNS0_16MemoryPermissionES5_
    .hidden  _ZN2nn3svc7aarch328profiler18CreateSharedMemoryEPNS0_6HandleEjNS0_16MemoryPermissionES5_
    .type    _ZN2nn3svc7aarch328profiler18CreateSharedMemoryEPNS0_6HandleEjNS0_16MemoryPermissionES5_, %function
_ZN2nn3svc7aarch328profiler18CreateSharedMemoryEPNS0_6HandleEjNS0_16MemoryPermissionES5_:

    push     {r0}

    svc      #NN_SVC_ID_CREATE_SHARED_MEMORY

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler18CreateSharedMemoryEPNS0_6HandleEjNS0_16MemoryPermissionES5_, [.-_ZN2nn3svc7aarch328profiler18CreateSharedMemoryEPNS0_6HandleEjNS0_16MemoryPermissionES5_]


//-------------------------------------------------
// Result MapTransferMemory(nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission ownerPermission)
//
//     AArch32 s=4 r=4 p=4                  Invariant s=4 r=8 p=4
// in  abi                                  svc
//     Register 0       4 handle            Register 0       4 handle
//     Register 1       4 addr              Register 1       4 addr
//     Register 2       4 size              Register 2       4 size
//     Register 3       4 ownerPermission   Register 3       4 ownerPermission
//
// out abi                                  svc
//     Register 0       4 return            Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler17MapTransferMemoryENS0_6HandleEjjNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler17MapTransferMemoryENS0_6HandleEjjNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch328profiler17MapTransferMemoryENS0_6HandleEjjNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch328profiler17MapTransferMemoryENS0_6HandleEjjNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch328profiler17MapTransferMemoryENS0_6HandleEjjNS0_16MemoryPermissionE:

    svc      #NN_SVC_ID_MAP_TRANSFER_MEMORY
    bx       lr

    .size _ZN2nn3svc7aarch328profiler17MapTransferMemoryENS0_6HandleEjjNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch328profiler17MapTransferMemoryENS0_6HandleEjjNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result UnmapTransferMemory(nn::svc::Handle handle, uintptr_t addr, size_t size)
//
//     AArch32 s=4 r=4 p=4         Invariant s=4 r=8 p=4
// in  abi                         svc
//     Register 0       4 handle   Register 0       4 handle
//     Register 1       4 addr     Register 1       4 addr
//     Register 2       4 size     Register 2       4 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler19UnmapTransferMemoryENS0_6HandleEjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler19UnmapTransferMemoryENS0_6HandleEjj
    .hidden  _ZN2nn3svc7aarch328profiler19UnmapTransferMemoryENS0_6HandleEjj
    .type    _ZN2nn3svc7aarch328profiler19UnmapTransferMemoryENS0_6HandleEjj, %function
_ZN2nn3svc7aarch328profiler19UnmapTransferMemoryENS0_6HandleEjj:

    svc      #NN_SVC_ID_UNMAP_TRANSFER_MEMORY
    bx       lr

    .size _ZN2nn3svc7aarch328profiler19UnmapTransferMemoryENS0_6HandleEjj, [.-_ZN2nn3svc7aarch328profiler19UnmapTransferMemoryENS0_6HandleEjj]


//-------------------------------------------------
// Result CreateInterruptEvent(nn::svc::Handle* pReadHandle, int32_t name, nn::svc::InterruptType type)
//
//     AArch32 s=4 r=4 p=4              Invariant s=4 r=8 p=4
// in  abi                              svc
//     Register 0  ref  4 pReadHandle   
//     Register 1       4 name          Register 1       4 name
//     Register 2       4 type          Register 2       4 type
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pReadHandle
//
// conversion
//   Scatter         pReadHandle

    .section .text._ZN2nn3svc7aarch328profiler20CreateInterruptEventEPNS0_6HandleEiNS0_13InterruptTypeE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler20CreateInterruptEventEPNS0_6HandleEiNS0_13InterruptTypeE
    .hidden  _ZN2nn3svc7aarch328profiler20CreateInterruptEventEPNS0_6HandleEiNS0_13InterruptTypeE
    .type    _ZN2nn3svc7aarch328profiler20CreateInterruptEventEPNS0_6HandleEiNS0_13InterruptTypeE, %function
_ZN2nn3svc7aarch328profiler20CreateInterruptEventEPNS0_6HandleEiNS0_13InterruptTypeE:

    push     {r0}

    svc      #NN_SVC_ID_CREATE_INTERRUPT_EVENT

    ldr      r2, [sp, #0]              // pReadHandleのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pReadHandle の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler20CreateInterruptEventEPNS0_6HandleEiNS0_13InterruptTypeE, [.-_ZN2nn3svc7aarch328profiler20CreateInterruptEventEPNS0_6HandleEiNS0_13InterruptTypeE]


//-------------------------------------------------
// Result QueryPhysicalAddress(nn::svc::ilp32::PhysicalMemoryInfo* pBlockInfo, uintptr_t addr)
//
//     AArch32 s=4 r=4 p=4             Invariant s=4 r=8 p=4
// in  abi                             svc
//     Register 0  ref 16 pBlockInfo   
//     Register 1       4 addr         Register 1       4 addr
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1      16 pBlockInfo
//                                     Register 2      16 pBlockInfo
//                                     Register 3      16 pBlockInfo
//                                     Register 4      16 pBlockInfo
//
// conversion
//   Scatter         pBlockInfo

    .section .text._ZN2nn3svc7aarch328profiler20QueryPhysicalAddressEPNS0_5ilp3218PhysicalMemoryInfoEj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler20QueryPhysicalAddressEPNS0_5ilp3218PhysicalMemoryInfoEj
    .hidden  _ZN2nn3svc7aarch328profiler20QueryPhysicalAddressEPNS0_5ilp3218PhysicalMemoryInfoEj
    .type    _ZN2nn3svc7aarch328profiler20QueryPhysicalAddressEPNS0_5ilp3218PhysicalMemoryInfoEj, %function
_ZN2nn3svc7aarch328profiler20QueryPhysicalAddressEPNS0_5ilp3218PhysicalMemoryInfoEj:

    push     {r0,r4,r5}

    svc      #NN_SVC_ID_QUERY_PHYSICAL_ADDRESS

    ldr      r5, [sp, #0]              // pBlockInfoのアドレス をスタックからレジスタへ
    str      r1, [r5, #0]              // pBlockInfo の第 1 ワードをレジスタからメモリへ
    str      r2, [r5, #4]              // pBlockInfo の第 2 ワードをレジスタからメモリへ
    str      r3, [r5, #8]              // pBlockInfo の第 3 ワードをレジスタからメモリへ
    str      r4, [r5, #12]             // pBlockInfo の第 4 ワードをレジスタからメモリへ

    add      sp, sp, #4
    pop      {r4,r5}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler20QueryPhysicalAddressEPNS0_5ilp3218PhysicalMemoryInfoEj, [.-_ZN2nn3svc7aarch328profiler20QueryPhysicalAddressEPNS0_5ilp3218PhysicalMemoryInfoEj]


//-------------------------------------------------
// Result QueryIoMapping(uintptr_t* pOut, nn::svc::PhysicalAddress physicalAddress, size_t size)
//
//     AArch32 s=4 r=4 p=4                  Invariant s=4 r=8 p=4
// in  abi                                  svc
//     Register 0  ref  4 pOut              Register 0       4 size
//     Register 2       8 physicalAddress   Register 2       8 physicalAddress
//     Register 3       8 physicalAddress   Register 3       8 physicalAddress
//     Stack    0       4 size              
//
// out abi                                  svc
//     Register 0       4 return            Register 0       4 return
//                                          Register 1       4 pOut
//
// conversion
//   Load            size
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler14QueryIoMappingEPjyj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler14QueryIoMappingEPjyj
    .hidden  _ZN2nn3svc7aarch328profiler14QueryIoMappingEPjyj
    .type    _ZN2nn3svc7aarch328profiler14QueryIoMappingEPjyj, %function
_ZN2nn3svc7aarch328profiler14QueryIoMappingEPjyj:

    push     {r0}

    ldr      r0, [sp, #4]              // size の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_QUERY_IO_MAPPING

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler14QueryIoMappingEPjyj, [.-_ZN2nn3svc7aarch328profiler14QueryIoMappingEPjyj]


//-------------------------------------------------
// Result CreateDeviceAddressSpace(nn::svc::Handle* pOut, uint64_t spaceAddress, uint64_t spaceSize)
//
//     AArch32 s=4 r=4 p=4               Invariant s=4 r=8 p=4
// in  abi                               svc
//     Register 0  ref  4 pOut           Register 0       8 spaceSize
//                                       Register 1       8 spaceSize
//     Register 2       8 spaceAddress   Register 2       8 spaceAddress
//     Register 3       8 spaceAddress   Register 3       8 spaceAddress
//     Stack    0       8 spaceSize      
//     Stack    1       8 spaceSize      
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//                                       Register 1       4 pOut
//
// conversion
//   Load            spaceSize
//   Load            spaceSize
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch328profiler24CreateDeviceAddressSpaceEPNS0_6HandleEyy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler24CreateDeviceAddressSpaceEPNS0_6HandleEyy
    .hidden  _ZN2nn3svc7aarch328profiler24CreateDeviceAddressSpaceEPNS0_6HandleEyy
    .type    _ZN2nn3svc7aarch328profiler24CreateDeviceAddressSpaceEPNS0_6HandleEyy, %function
_ZN2nn3svc7aarch328profiler24CreateDeviceAddressSpaceEPNS0_6HandleEyy:

    push     {r0}

    ldr      r0, [sp, #4]              // spaceSize の値 をスタックからレジスタへ
    ldr      r1, [sp, #8]              // spaceSize の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_CREATE_DEVICE_ADDRESS_SPACE

    ldr      r2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    bx       lr

    .size _ZN2nn3svc7aarch328profiler24CreateDeviceAddressSpaceEPNS0_6HandleEyy, [.-_ZN2nn3svc7aarch328profiler24CreateDeviceAddressSpaceEPNS0_6HandleEyy]


//-------------------------------------------------
// Result AttachDeviceAddressSpace(nn::svc::DeviceName deviceName, nn::svc::Handle handle)
//
//     AArch32 s=4 r=4 p=4             Invariant s=4 r=8 p=4
// in  abi                             svc
//     Register 0       4 deviceName   Register 0       4 deviceName
//     Register 1       4 handle       Register 1       4 handle
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler24AttachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler24AttachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler24AttachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler24AttachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler24AttachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE:

    svc      #NN_SVC_ID_ATTACH_DEVICE_ADDRESS_SPACE
    bx       lr

    .size _ZN2nn3svc7aarch328profiler24AttachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler24AttachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE]


//-------------------------------------------------
// Result DetachDeviceAddressSpace(nn::svc::DeviceName deviceName, nn::svc::Handle handle)
//
//     AArch32 s=4 r=4 p=4             Invariant s=4 r=8 p=4
// in  abi                             svc
//     Register 0       4 deviceName   Register 0       4 deviceName
//     Register 1       4 handle       Register 1       4 handle
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch328profiler24DetachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler24DetachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch328profiler24DetachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE
    .type    _ZN2nn3svc7aarch328profiler24DetachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE, %function
_ZN2nn3svc7aarch328profiler24DetachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE:

    svc      #NN_SVC_ID_DETACH_DEVICE_ADDRESS_SPACE
    bx       lr

    .size _ZN2nn3svc7aarch328profiler24DetachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE, [.-_ZN2nn3svc7aarch328profiler24DetachDeviceAddressSpaceENS0_10DeviceNameENS0_6HandleE]


//-------------------------------------------------
// Result MapDeviceAddressSpaceByForce(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
//
//     AArch32 s=4 r=4 p=4                   Invariant s=4 r=8 p=4
// in  abi                                   svc
//     Register 0       4 addressSpace       Register 0       4 addressSpace
//     Register 1       4 process            Register 1       4 process
//     Register 2       8 processAddress     Register 2       8 processAddress
//     Register 3       8 processAddress     Register 3       8 processAddress
//                                           Register 4       4 size
//                                           Register 5       8 deviceAddress
//                                           Register 6       8 deviceAddress
//                                           Register 7       4 devicePermission
//     Stack    0       4 size               
//     Stack    2       8 deviceAddress      
//     Stack    3       8 deviceAddress      
//     Stack    4       4 devicePermission   
//
// out abi                                   svc
//     Register 0       4 return             Register 0       4 return
//
// conversion
//   Load            size
//   Load            deviceAddress
//   Load            deviceAddress
//   Load            devicePermission

    .section .text._ZN2nn3svc7aarch328profiler28MapDeviceAddressSpaceByForceENS0_6HandleES3_yjyNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler28MapDeviceAddressSpaceByForceENS0_6HandleES3_yjyNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch328profiler28MapDeviceAddressSpaceByForceENS0_6HandleES3_yjyNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch328profiler28MapDeviceAddressSpaceByForceENS0_6HandleES3_yjyNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch328profiler28MapDeviceAddressSpaceByForceENS0_6HandleES3_yjyNS0_16MemoryPermissionE:

    push     {r4,r5,r6,r7}

    ldr      r4, [sp, #16]             // size の値 をスタックからレジスタへ
    ldr      r5, [sp, #24]             // deviceAddress の値 をスタックからレジスタへ
    ldr      r6, [sp, #28]             // deviceAddress の値 をスタックからレジスタへ
    ldr      r7, [sp, #32]             // devicePermission の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_MAP_DEVICE_ADDRESS_SPACE_BY_FORCE

    pop      {r4,r5,r6,r7}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler28MapDeviceAddressSpaceByForceENS0_6HandleES3_yjyNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch328profiler28MapDeviceAddressSpaceByForceENS0_6HandleES3_yjyNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result MapDeviceAddressSpaceAligned(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
//
//     AArch32 s=4 r=4 p=4                   Invariant s=4 r=8 p=4
// in  abi                                   svc
//     Register 0       4 addressSpace       Register 0       4 addressSpace
//     Register 1       4 process            Register 1       4 process
//     Register 2       8 processAddress     Register 2       8 processAddress
//     Register 3       8 processAddress     Register 3       8 processAddress
//                                           Register 4       4 size
//                                           Register 5       8 deviceAddress
//                                           Register 6       8 deviceAddress
//                                           Register 7       4 devicePermission
//     Stack    0       4 size               
//     Stack    2       8 deviceAddress      
//     Stack    3       8 deviceAddress      
//     Stack    4       4 devicePermission   
//
// out abi                                   svc
//     Register 0       4 return             Register 0       4 return
//
// conversion
//   Load            size
//   Load            deviceAddress
//   Load            deviceAddress
//   Load            devicePermission

    .section .text._ZN2nn3svc7aarch328profiler28MapDeviceAddressSpaceAlignedENS0_6HandleES3_yjyNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler28MapDeviceAddressSpaceAlignedENS0_6HandleES3_yjyNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch328profiler28MapDeviceAddressSpaceAlignedENS0_6HandleES3_yjyNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch328profiler28MapDeviceAddressSpaceAlignedENS0_6HandleES3_yjyNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch328profiler28MapDeviceAddressSpaceAlignedENS0_6HandleES3_yjyNS0_16MemoryPermissionE:

    push     {r4,r5,r6,r7}

    ldr      r4, [sp, #16]             // size の値 をスタックからレジスタへ
    ldr      r5, [sp, #24]             // deviceAddress の値 をスタックからレジスタへ
    ldr      r6, [sp, #28]             // deviceAddress の値 をスタックからレジスタへ
    ldr      r7, [sp, #32]             // devicePermission の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_MAP_DEVICE_ADDRESS_SPACE_ALIGNED

    pop      {r4,r5,r6,r7}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler28MapDeviceAddressSpaceAlignedENS0_6HandleES3_yjyNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch328profiler28MapDeviceAddressSpaceAlignedENS0_6HandleES3_yjyNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result MapDeviceAddressSpace(size_t* pMappedSize, nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress, nn::svc::MemoryPermission devicePermission)
//
//     AArch32 s=4 r=4 p=4                   Invariant s=4 r=8 p=4
// in  abi                                   svc
//     Register 0  ref  4 pMappedSize        Register 0       8 processAddress
//     Register 1       4 addressSpace       Register 1       4 addressSpace
//     Register 2       4 process            Register 2       4 process
//                                           Register 3       8 processAddress
//                                           Register 4       4 size
//                                           Register 5       8 deviceAddress
//                                           Register 6       8 deviceAddress
//                                           Register 7       4 devicePermission
//     Stack    0       8 processAddress     
//     Stack    1       8 processAddress     
//     Stack    2       4 size               
//     Stack    4       8 deviceAddress      
//     Stack    5       8 deviceAddress      
//     Stack    6       4 devicePermission   
//
// out abi                                   svc
//     Register 0       4 return             Register 0       4 return
//                                           Register 1       4 pMappedSize
//
// conversion
//   Load            processAddress
//   Load            processAddress
//   Load            size
//   Load            deviceAddress
//   Load            deviceAddress
//   Load            devicePermission
//   Scatter         pMappedSize

    .section .text._ZN2nn3svc7aarch328profiler21MapDeviceAddressSpaceEPjNS0_6HandleES4_yjyNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler21MapDeviceAddressSpaceEPjNS0_6HandleES4_yjyNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch328profiler21MapDeviceAddressSpaceEPjNS0_6HandleES4_yjyNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch328profiler21MapDeviceAddressSpaceEPjNS0_6HandleES4_yjyNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch328profiler21MapDeviceAddressSpaceEPjNS0_6HandleES4_yjyNS0_16MemoryPermissionE:

    push     {r0,r4,r5,r6,r7}

    ldr      r0, [sp, #20]             // processAddress の値 をスタックからレジスタへ
    ldr      r3, [sp, #24]             // processAddress の値 をスタックからレジスタへ
    ldr      r4, [sp, #28]             // size の値 をスタックからレジスタへ
    ldr      r5, [sp, #36]             // deviceAddress の値 をスタックからレジスタへ
    ldr      r6, [sp, #40]             // deviceAddress の値 をスタックからレジスタへ
    ldr      r7, [sp, #44]             // devicePermission の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_MAP_DEVICE_ADDRESS_SPACE

    ldr      r2, [sp, #0]              // pMappedSizeのアドレス をスタックからレジスタへ
    str      r1, [r2, #0]              // pMappedSize の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #4
    pop      {r4,r5,r6,r7}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler21MapDeviceAddressSpaceEPjNS0_6HandleES4_yjyNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch328profiler21MapDeviceAddressSpaceEPjNS0_6HandleES4_yjyNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result UnmapDeviceAddressSpace(nn::svc::Handle addressSpace, nn::svc::Handle process, uint64_t processAddress, size_t size, uint64_t deviceAddress)
//
//     AArch32 s=4 r=4 p=4                 Invariant s=4 r=8 p=4
// in  abi                                 svc
//     Register 0       4 addressSpace     Register 0       4 addressSpace
//     Register 1       4 process          Register 1       4 process
//     Register 2       8 processAddress   Register 2       8 processAddress
//     Register 3       8 processAddress   Register 3       8 processAddress
//                                         Register 4       4 size
//                                         Register 5       8 deviceAddress
//                                         Register 6       8 deviceAddress
//     Stack    0       4 size             
//     Stack    2       8 deviceAddress    
//     Stack    3       8 deviceAddress    
//
// out abi                                 svc
//     Register 0       4 return           Register 0       4 return
//
// conversion
//   Load            size
//   Load            deviceAddress
//   Load            deviceAddress

    .section .text._ZN2nn3svc7aarch328profiler23UnmapDeviceAddressSpaceENS0_6HandleES3_yjy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler23UnmapDeviceAddressSpaceENS0_6HandleES3_yjy
    .hidden  _ZN2nn3svc7aarch328profiler23UnmapDeviceAddressSpaceENS0_6HandleES3_yjy
    .type    _ZN2nn3svc7aarch328profiler23UnmapDeviceAddressSpaceENS0_6HandleES3_yjy, %function
_ZN2nn3svc7aarch328profiler23UnmapDeviceAddressSpaceENS0_6HandleES3_yjy:

    push     {r4,r5,r6}

    ldr      r4, [sp, #12]             // size の値 をスタックからレジスタへ
    ldr      r5, [sp, #20]             // deviceAddress の値 をスタックからレジスタへ
    ldr      r6, [sp, #24]             // deviceAddress の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_UNMAP_DEVICE_ADDRESS_SPACE

    pop      {r4,r5,r6}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler23UnmapDeviceAddressSpaceENS0_6HandleES3_yjy, [.-_ZN2nn3svc7aarch328profiler23UnmapDeviceAddressSpaceENS0_6HandleES3_yjy]


//-------------------------------------------------
// Result InvalidateProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
//
//     AArch32 s=4 r=4 p=4          Invariant s=4 r=8 p=4
// in  abi                          svc
//     Register 0       4 process   Register 0       4 process
//                                  Register 1       8 size
//     Register 2       8 addr      Register 2       8 addr
//     Register 3       8 addr      Register 3       8 addr
//                                  Register 4       8 size
//     Stack    0       8 size      
//     Stack    1       8 size      
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion
//   Load            size
//   Load            size

    .section .text._ZN2nn3svc7aarch328profiler26InvalidateProcessDataCacheENS0_6HandleEyy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler26InvalidateProcessDataCacheENS0_6HandleEyy
    .hidden  _ZN2nn3svc7aarch328profiler26InvalidateProcessDataCacheENS0_6HandleEyy
    .type    _ZN2nn3svc7aarch328profiler26InvalidateProcessDataCacheENS0_6HandleEyy, %function
_ZN2nn3svc7aarch328profiler26InvalidateProcessDataCacheENS0_6HandleEyy:

    push     {r4}

    ldr      r1, [sp, #4]              // size の値 をスタックからレジスタへ
    ldr      r4, [sp, #8]              // size の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_INVALIDATE_PROCESS_DATA_CACHE

    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler26InvalidateProcessDataCacheENS0_6HandleEyy, [.-_ZN2nn3svc7aarch328profiler26InvalidateProcessDataCacheENS0_6HandleEyy]


//-------------------------------------------------
// Result StoreProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
//
//     AArch32 s=4 r=4 p=4          Invariant s=4 r=8 p=4
// in  abi                          svc
//     Register 0       4 process   Register 0       4 process
//                                  Register 1       8 size
//     Register 2       8 addr      Register 2       8 addr
//     Register 3       8 addr      Register 3       8 addr
//                                  Register 4       8 size
//     Stack    0       8 size      
//     Stack    1       8 size      
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion
//   Load            size
//   Load            size

    .section .text._ZN2nn3svc7aarch328profiler21StoreProcessDataCacheENS0_6HandleEyy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler21StoreProcessDataCacheENS0_6HandleEyy
    .hidden  _ZN2nn3svc7aarch328profiler21StoreProcessDataCacheENS0_6HandleEyy
    .type    _ZN2nn3svc7aarch328profiler21StoreProcessDataCacheENS0_6HandleEyy, %function
_ZN2nn3svc7aarch328profiler21StoreProcessDataCacheENS0_6HandleEyy:

    push     {r4}

    ldr      r1, [sp, #4]              // size の値 をスタックからレジスタへ
    ldr      r4, [sp, #8]              // size の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_STORE_PROCESS_DATA_CACHE

    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler21StoreProcessDataCacheENS0_6HandleEyy, [.-_ZN2nn3svc7aarch328profiler21StoreProcessDataCacheENS0_6HandleEyy]


//-------------------------------------------------
// Result FlushProcessDataCache(nn::svc::Handle process, uint64_t addr, uint64_t size)
//
//     AArch32 s=4 r=4 p=4          Invariant s=4 r=8 p=4
// in  abi                          svc
//     Register 0       4 process   Register 0       4 process
//                                  Register 1       8 size
//     Register 2       8 addr      Register 2       8 addr
//     Register 3       8 addr      Register 3       8 addr
//                                  Register 4       8 size
//     Stack    0       8 size      
//     Stack    1       8 size      
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion
//   Load            size
//   Load            size

    .section .text._ZN2nn3svc7aarch328profiler21FlushProcessDataCacheENS0_6HandleEyy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch328profiler21FlushProcessDataCacheENS0_6HandleEyy
    .hidden  _ZN2nn3svc7aarch328profiler21FlushProcessDataCacheENS0_6HandleEyy
    .type    _ZN2nn3svc7aarch328profiler21FlushProcessDataCacheENS0_6HandleEyy, %function
_ZN2nn3svc7aarch328profiler21FlushProcessDataCacheENS0_6HandleEyy:

    push     {r4}

    ldr      r1, [sp, #4]              // size の値 をスタックからレジスタへ
    ldr      r4, [sp, #8]              // size の値 をスタックからレジスタへ

    svc      #NN_SVC_ID_FLUSH_PROCESS_DATA_CACHE

    pop      {r4}
    bx       lr

    .size _ZN2nn3svc7aarch328profiler21FlushProcessDataCacheENS0_6HandleEyy, [.-_ZN2nn3svc7aarch328profiler21FlushProcessDataCacheENS0_6HandleEyy]


    .end

