﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/*
 * このファイルを編集しないでください。
 * このファイルは自動生成されます。
 */

#include <nn/svc/svc_BaseId.autogen.h>


//-------------------------------------------------
// Result SetHeapSize(uintptr_t* pOut, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1       4 size     Register 1       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp328profiler11SetHeapSizeEPmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler11SetHeapSizeEPmm
    .hidden  _ZN2nn3svc7aarch645ilp328profiler11SetHeapSizeEPmm
    .type    _ZN2nn3svc7aarch645ilp328profiler11SetHeapSizeEPmm, %function
_ZN2nn3svc7aarch645ilp328profiler11SetHeapSizeEPmm:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_SET_HEAP_SIZE

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler11SetHeapSizeEPmm, [.-_ZN2nn3svc7aarch645ilp328profiler11SetHeapSizeEPmm]


//-------------------------------------------------
// Result SetMemoryPermission(uintptr_t addr, size_t size, nn::svc::MemoryPermission permission)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0       4 addr         Register 0       8 addr
//     Register 1       4 size         Register 1       8 size
//     Register 2       4 permission   Register 2       4 permission
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler19SetMemoryPermissionEmmNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler19SetMemoryPermissionEmmNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler19SetMemoryPermissionEmmNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch645ilp328profiler19SetMemoryPermissionEmmNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch645ilp328profiler19SetMemoryPermissionEmmNS0_16MemoryPermissionE:

    svc      #NN_SVC_ID_SET_MEMORY_PERMISSION
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler19SetMemoryPermissionEmmNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch645ilp328profiler19SetMemoryPermissionEmmNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result SetMemoryAttribute(uintptr_t addr, size_t size, nn::Bit32 mask, nn::Bit32 attribute)
//
//     AArch64 s=8 r=8 p=4            Invariant s=8 r=8 p=8
// in  abi                            svc
//     Register 0       4 addr        Register 0       8 addr
//     Register 1       4 size        Register 1       8 size
//     Register 2       4 mask        Register 2       4 mask
//     Register 3       4 attribute   Register 3       4 attribute
//
// out abi                            svc
//     Register 0       4 return      Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler18SetMemoryAttributeEmmjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler18SetMemoryAttributeEmmjj
    .hidden  _ZN2nn3svc7aarch645ilp328profiler18SetMemoryAttributeEmmjj
    .type    _ZN2nn3svc7aarch645ilp328profiler18SetMemoryAttributeEmmjj, %function
_ZN2nn3svc7aarch645ilp328profiler18SetMemoryAttributeEmmjj:

    svc      #NN_SVC_ID_SET_MEMORY_ATTRIBUTE
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler18SetMemoryAttributeEmmjj, [.-_ZN2nn3svc7aarch645ilp328profiler18SetMemoryAttributeEmmjj]


//-------------------------------------------------
// Result MapMemory(uintptr_t toAddr, uintptr_t fromAddr, size_t size)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 toAddr     Register 0       8 toAddr
//     Register 1       4 fromAddr   Register 1       8 fromAddr
//     Register 2       4 size       Register 2       8 size
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler9MapMemoryEmmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler9MapMemoryEmmm
    .hidden  _ZN2nn3svc7aarch645ilp328profiler9MapMemoryEmmm
    .type    _ZN2nn3svc7aarch645ilp328profiler9MapMemoryEmmm, %function
_ZN2nn3svc7aarch645ilp328profiler9MapMemoryEmmm:

    svc      #NN_SVC_ID_MAP_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler9MapMemoryEmmm, [.-_ZN2nn3svc7aarch645ilp328profiler9MapMemoryEmmm]


//-------------------------------------------------
// Result UnmapMemory(uintptr_t toAddr, uintptr_t fromAddr, size_t size)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 toAddr     Register 0       8 toAddr
//     Register 1       4 fromAddr   Register 1       8 fromAddr
//     Register 2       4 size       Register 2       8 size
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler11UnmapMemoryEmmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler11UnmapMemoryEmmm
    .hidden  _ZN2nn3svc7aarch645ilp328profiler11UnmapMemoryEmmm
    .type    _ZN2nn3svc7aarch645ilp328profiler11UnmapMemoryEmmm, %function
_ZN2nn3svc7aarch645ilp328profiler11UnmapMemoryEmmm:

    svc      #NN_SVC_ID_UNMAP_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler11UnmapMemoryEmmm, [.-_ZN2nn3svc7aarch645ilp328profiler11UnmapMemoryEmmm]


//-------------------------------------------------
// Result QueryMemory(nn::svc::lp64::MemoryInfo* pBlockInfo, nn::svc::PageInfo* pPageInfo, uintptr_t addr)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0  ref 40 pBlockInfo   Register 0  ref 40 pBlockInfo
//     Register 1  ref  4 pPageInfo    
//     Register 2       4 addr         Register 2       8 addr
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1       4 pPageInfo
//
// conversion
//   Scatter         pPageInfo

    .section .text._ZN2nn3svc7aarch645ilp328profiler11QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler11QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm
    .hidden  _ZN2nn3svc7aarch645ilp328profiler11QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm
    .type    _ZN2nn3svc7aarch645ilp328profiler11QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm, %function
_ZN2nn3svc7aarch645ilp328profiler11QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm:

    str      x1, [sp, #-16]!

    svc      #NN_SVC_ID_QUERY_MEMORY

    ldr      x2, [sp, #0]              // pPageInfoのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pPageInfo の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler11QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm, [.-_ZN2nn3svc7aarch645ilp328profiler11QueryMemoryEPNS0_4lp6410MemoryInfoEPNS0_8PageInfoEm]


//-------------------------------------------------
// void ExitProcess()
//
//     AArch64 s=8 r=8 p=4   Invariant s=8 r=8 p=8
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler11ExitProcessEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler11ExitProcessEv
    .hidden  _ZN2nn3svc7aarch645ilp328profiler11ExitProcessEv
    .type    _ZN2nn3svc7aarch645ilp328profiler11ExitProcessEv, %function
_ZN2nn3svc7aarch645ilp328profiler11ExitProcessEv:

    svc      #NN_SVC_ID_EXIT_PROCESS
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler11ExitProcessEv, [.-_ZN2nn3svc7aarch645ilp328profiler11ExitProcessEv]


//-------------------------------------------------
// Result CreateThread(nn::svc::Handle* pOut, nn::svc::lp64::ThreadFunc f, uintptr_t param, uintptr_t stackBottom, int32_t priority, int32_t idealCore)
//
//     AArch64 s=8 r=8 p=4              Invariant s=8 r=8 p=8
// in  abi                              svc
//     Register 0  ref  4 pOut          
//     Register 1       8 f             Register 1       8 f
//     Register 2       4 param         Register 2       8 param
//     Register 3       4 stackBottom   Register 3       8 stackBottom
//     Register 4       4 priority      Register 4       4 priority
//     Register 5       4 idealCore     Register 5       4 idealCore
//
// out abi                              svc
//     Register 0       4 return        Register 0       4 return
//                                      Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp328profiler12CreateThreadEPNS0_6HandleEmmmii, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler12CreateThreadEPNS0_6HandleEmmmii
    .hidden  _ZN2nn3svc7aarch645ilp328profiler12CreateThreadEPNS0_6HandleEmmmii
    .type    _ZN2nn3svc7aarch645ilp328profiler12CreateThreadEPNS0_6HandleEmmmii, %function
_ZN2nn3svc7aarch645ilp328profiler12CreateThreadEPNS0_6HandleEmmmii:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_THREAD

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler12CreateThreadEPNS0_6HandleEmmmii, [.-_ZN2nn3svc7aarch645ilp328profiler12CreateThreadEPNS0_6HandleEmmmii]


//-------------------------------------------------
// Result StartThread(nn::svc::Handle thread)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 thread   Register 0       4 thread
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler11StartThreadENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler11StartThreadENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler11StartThreadENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp328profiler11StartThreadENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp328profiler11StartThreadENS0_6HandleE:

    svc      #NN_SVC_ID_START_THREAD
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler11StartThreadENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp328profiler11StartThreadENS0_6HandleE]


//-------------------------------------------------
// void ExitThread()
//
//     AArch64 s=8 r=8 p=4   Invariant s=8 r=8 p=8
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler10ExitThreadEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler10ExitThreadEv
    .hidden  _ZN2nn3svc7aarch645ilp328profiler10ExitThreadEv
    .type    _ZN2nn3svc7aarch645ilp328profiler10ExitThreadEv, %function
_ZN2nn3svc7aarch645ilp328profiler10ExitThreadEv:

    svc      #NN_SVC_ID_EXIT_THREAD
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler10ExitThreadEv, [.-_ZN2nn3svc7aarch645ilp328profiler10ExitThreadEv]


//-------------------------------------------------
// void SleepThread(int64_t ns)
//
//     AArch64 s=8 r=8 p=4     Invariant s=8 r=8 p=8
// in  abi                     svc
//     Register 0       8 ns   Register 0       8 ns
//
// out abi                     svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler11SleepThreadEx, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler11SleepThreadEx
    .hidden  _ZN2nn3svc7aarch645ilp328profiler11SleepThreadEx
    .type    _ZN2nn3svc7aarch645ilp328profiler11SleepThreadEx, %function
_ZN2nn3svc7aarch645ilp328profiler11SleepThreadEx:

    svc      #NN_SVC_ID_SLEEP_THREAD
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler11SleepThreadEx, [.-_ZN2nn3svc7aarch645ilp328profiler11SleepThreadEx]


//-------------------------------------------------
// Result GetThreadPriority(int32_t* pOut, nn::svc::Handle thread)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1       4 thread   Register 1       4 thread
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp328profiler17GetThreadPriorityEPiNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler17GetThreadPriorityEPiNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler17GetThreadPriorityEPiNS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp328profiler17GetThreadPriorityEPiNS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp328profiler17GetThreadPriorityEPiNS0_6HandleE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_THREAD_PRIORITY

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler17GetThreadPriorityEPiNS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp328profiler17GetThreadPriorityEPiNS0_6HandleE]


//-------------------------------------------------
// Result SetThreadPriority(nn::svc::Handle thread, int32_t priority)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 thread     Register 0       4 thread
//     Register 1       4 priority   Register 1       4 priority
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler17SetThreadPriorityENS0_6HandleEi, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler17SetThreadPriorityENS0_6HandleEi
    .hidden  _ZN2nn3svc7aarch645ilp328profiler17SetThreadPriorityENS0_6HandleEi
    .type    _ZN2nn3svc7aarch645ilp328profiler17SetThreadPriorityENS0_6HandleEi, %function
_ZN2nn3svc7aarch645ilp328profiler17SetThreadPriorityENS0_6HandleEi:

    svc      #NN_SVC_ID_SET_THREAD_PRIORITY
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler17SetThreadPriorityENS0_6HandleEi, [.-_ZN2nn3svc7aarch645ilp328profiler17SetThreadPriorityENS0_6HandleEi]


//-------------------------------------------------
// Result GetThreadCoreMask(int32_t* pIdealCore, nn::Bit64* pAffinityMask, nn::svc::Handle thread)
//
//     AArch64 s=8 r=8 p=4                Invariant s=8 r=8 p=8
// in  abi                                svc
//     Register 0  ref  4 pIdealCore      
//     Register 1  ref  8 pAffinityMask   
//     Register 2       4 thread          Register 2       4 thread
//
// out abi                                svc
//     Register 0       4 return          Register 0       4 return
//                                        Register 1       4 pIdealCore
//                                        Register 2       8 pAffinityMask
//
// conversion
//   Scatter         pIdealCore
//   Scatter         pAffinityMask

    .section .text._ZN2nn3svc7aarch645ilp328profiler17GetThreadCoreMaskEPiPyNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler17GetThreadCoreMaskEPiPyNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler17GetThreadCoreMaskEPiPyNS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp328profiler17GetThreadCoreMaskEPiPyNS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp328profiler17GetThreadCoreMaskEPiPyNS0_6HandleE:

    stp      x0, x1, [sp, #-16]!

    svc      #NN_SVC_ID_GET_THREAD_CORE_MASK

    ldr      x3, [sp, #0]              // pIdealCoreのアドレス をスタックからレジスタへ
    str      w1, [x3, #0]              // pIdealCore の第 1 ワードをレジスタからメモリへ
    ldr      x3, [sp, #8]              // pAffinityMaskのアドレス をスタックからレジスタへ
    str      x2, [x3, #0]              // pAffinityMask の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler17GetThreadCoreMaskEPiPyNS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp328profiler17GetThreadCoreMaskEPiPyNS0_6HandleE]


//-------------------------------------------------
// Result SetThreadCoreMask(nn::svc::Handle thread, int32_t idealCore, nn::Bit64 affinityMask)
//
//     AArch64 s=8 r=8 p=4               Invariant s=8 r=8 p=8
// in  abi                               svc
//     Register 0       4 thread         Register 0       4 thread
//     Register 1       4 idealCore      Register 1       4 idealCore
//     Register 2       8 affinityMask   Register 2       8 affinityMask
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler17SetThreadCoreMaskENS0_6HandleEiy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler17SetThreadCoreMaskENS0_6HandleEiy
    .hidden  _ZN2nn3svc7aarch645ilp328profiler17SetThreadCoreMaskENS0_6HandleEiy
    .type    _ZN2nn3svc7aarch645ilp328profiler17SetThreadCoreMaskENS0_6HandleEiy, %function
_ZN2nn3svc7aarch645ilp328profiler17SetThreadCoreMaskENS0_6HandleEiy:

    svc      #NN_SVC_ID_SET_THREAD_CORE_MASK
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler17SetThreadCoreMaskENS0_6HandleEiy, [.-_ZN2nn3svc7aarch645ilp328profiler17SetThreadCoreMaskENS0_6HandleEiy]


//-------------------------------------------------
// int32_t GetCurrentProcessorNumber()
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler25GetCurrentProcessorNumberEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler25GetCurrentProcessorNumberEv
    .hidden  _ZN2nn3svc7aarch645ilp328profiler25GetCurrentProcessorNumberEv
    .type    _ZN2nn3svc7aarch645ilp328profiler25GetCurrentProcessorNumberEv, %function
_ZN2nn3svc7aarch645ilp328profiler25GetCurrentProcessorNumberEv:

    svc      #NN_SVC_ID_GET_CURRENT_PROCESSOR_NUMBER
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler25GetCurrentProcessorNumberEv, [.-_ZN2nn3svc7aarch645ilp328profiler25GetCurrentProcessorNumberEv]


//-------------------------------------------------
// Result SignalEvent(nn::svc::Handle event)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 event    Register 0       4 event
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler11SignalEventENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler11SignalEventENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler11SignalEventENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp328profiler11SignalEventENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp328profiler11SignalEventENS0_6HandleE:

    svc      #NN_SVC_ID_SIGNAL_EVENT
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler11SignalEventENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp328profiler11SignalEventENS0_6HandleE]


//-------------------------------------------------
// Result ClearEvent(nn::svc::Handle event)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 event    Register 0       4 event
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler10ClearEventENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler10ClearEventENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler10ClearEventENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp328profiler10ClearEventENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp328profiler10ClearEventENS0_6HandleE:

    svc      #NN_SVC_ID_CLEAR_EVENT
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler10ClearEventENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp328profiler10ClearEventENS0_6HandleE]


//-------------------------------------------------
// Result MapSharedMemory(nn::svc::Handle handle, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission)
//
//     AArch64 s=8 r=8 p=4               Invariant s=8 r=8 p=8
// in  abi                               svc
//     Register 0       4 handle         Register 0       4 handle
//     Register 1       4 addr           Register 1       8 addr
//     Register 2       4 size           Register 2       8 size
//     Register 3       4 myPermission   Register 3       4 myPermission
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler15MapSharedMemoryENS0_6HandleEmmNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler15MapSharedMemoryENS0_6HandleEmmNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler15MapSharedMemoryENS0_6HandleEmmNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch645ilp328profiler15MapSharedMemoryENS0_6HandleEmmNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch645ilp328profiler15MapSharedMemoryENS0_6HandleEmmNS0_16MemoryPermissionE:

    svc      #NN_SVC_ID_MAP_SHARED_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler15MapSharedMemoryENS0_6HandleEmmNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch645ilp328profiler15MapSharedMemoryENS0_6HandleEmmNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result UnmapSharedMemory(nn::svc::Handle handle, uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 handle   Register 0       4 handle
//     Register 1       4 addr     Register 1       8 addr
//     Register 2       4 size     Register 2       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler17UnmapSharedMemoryENS0_6HandleEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler17UnmapSharedMemoryENS0_6HandleEmm
    .hidden  _ZN2nn3svc7aarch645ilp328profiler17UnmapSharedMemoryENS0_6HandleEmm
    .type    _ZN2nn3svc7aarch645ilp328profiler17UnmapSharedMemoryENS0_6HandleEmm, %function
_ZN2nn3svc7aarch645ilp328profiler17UnmapSharedMemoryENS0_6HandleEmm:

    svc      #NN_SVC_ID_UNMAP_SHARED_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler17UnmapSharedMemoryENS0_6HandleEmm, [.-_ZN2nn3svc7aarch645ilp328profiler17UnmapSharedMemoryENS0_6HandleEmm]


//-------------------------------------------------
// Result CreateTransferMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size, nn::svc::MemoryPermission myPermission)
//
//     AArch64 s=8 r=8 p=4               Invariant s=8 r=8 p=8
// in  abi                               svc
//     Register 0  ref  4 pOut           
//     Register 1       4 addr           Register 1       8 addr
//     Register 2       4 size           Register 2       8 size
//     Register 3       4 myPermission   Register 3       4 myPermission
//
// out abi                               svc
//     Register 0       4 return         Register 0       4 return
//                                       Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp328profiler20CreateTransferMemoryEPNS0_6HandleEmmNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler20CreateTransferMemoryEPNS0_6HandleEmmNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler20CreateTransferMemoryEPNS0_6HandleEmmNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch645ilp328profiler20CreateTransferMemoryEPNS0_6HandleEmmNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch645ilp328profiler20CreateTransferMemoryEPNS0_6HandleEmmNS0_16MemoryPermissionE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_TRANSFER_MEMORY

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler20CreateTransferMemoryEPNS0_6HandleEmmNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch645ilp328profiler20CreateTransferMemoryEPNS0_6HandleEmmNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result CloseHandle(nn::svc::Handle handle)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 handle   Register 0       4 handle
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler11CloseHandleENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler11CloseHandleENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler11CloseHandleENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp328profiler11CloseHandleENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp328profiler11CloseHandleENS0_6HandleE:

    svc      #NN_SVC_ID_CLOSE_HANDLE
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler11CloseHandleENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp328profiler11CloseHandleENS0_6HandleE]


//-------------------------------------------------
// Result ResetSignal(nn::svc::Handle handle)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 handle   Register 0       4 handle
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler11ResetSignalENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler11ResetSignalENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler11ResetSignalENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp328profiler11ResetSignalENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp328profiler11ResetSignalENS0_6HandleE:

    svc      #NN_SVC_ID_RESET_SIGNAL
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler11ResetSignalENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp328profiler11ResetSignalENS0_6HandleE]


//-------------------------------------------------
// Result WaitSynchronization(int32_t* pOut, const nn::svc::Handle handles[], int32_t numHandles, int64_t ns)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0  ref  4 pOut         
//     Register 1  ref -- handles      Register 1  ref -- handles
//     Register 2       4 numHandles   Register 2       4 numHandles
//     Register 3       8 ns           Register 3       8 ns
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp328profiler19WaitSynchronizationEPiPKNS0_6HandleEix, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler19WaitSynchronizationEPiPKNS0_6HandleEix
    .hidden  _ZN2nn3svc7aarch645ilp328profiler19WaitSynchronizationEPiPKNS0_6HandleEix
    .type    _ZN2nn3svc7aarch645ilp328profiler19WaitSynchronizationEPiPKNS0_6HandleEix, %function
_ZN2nn3svc7aarch645ilp328profiler19WaitSynchronizationEPiPKNS0_6HandleEix:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_WAIT_SYNCHRONIZATION

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler19WaitSynchronizationEPiPKNS0_6HandleEix, [.-_ZN2nn3svc7aarch645ilp328profiler19WaitSynchronizationEPiPKNS0_6HandleEix]


//-------------------------------------------------
// Result CancelSynchronization(nn::svc::Handle handle)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 handle   Register 0       4 handle
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler21CancelSynchronizationENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler21CancelSynchronizationENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler21CancelSynchronizationENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp328profiler21CancelSynchronizationENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp328profiler21CancelSynchronizationENS0_6HandleE:

    svc      #NN_SVC_ID_CANCEL_SYNCHRONIZATION
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler21CancelSynchronizationENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp328profiler21CancelSynchronizationENS0_6HandleE]


//-------------------------------------------------
// Result ArbitrateLock(nn::svc::Handle handle, uintptr_t addr, nn::Bit32 ownValue)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 handle     Register 0       4 handle
//     Register 1       4 addr       Register 1       8 addr
//     Register 2       4 ownValue   Register 2       4 ownValue
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler13ArbitrateLockENS0_6HandleEmj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler13ArbitrateLockENS0_6HandleEmj
    .hidden  _ZN2nn3svc7aarch645ilp328profiler13ArbitrateLockENS0_6HandleEmj
    .type    _ZN2nn3svc7aarch645ilp328profiler13ArbitrateLockENS0_6HandleEmj, %function
_ZN2nn3svc7aarch645ilp328profiler13ArbitrateLockENS0_6HandleEmj:

    svc      #NN_SVC_ID_ARBITRATE_LOCK
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler13ArbitrateLockENS0_6HandleEmj, [.-_ZN2nn3svc7aarch645ilp328profiler13ArbitrateLockENS0_6HandleEmj]


//-------------------------------------------------
// Result ArbitrateUnlock(uintptr_t addr)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 addr     Register 0       8 addr
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler15ArbitrateUnlockEm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler15ArbitrateUnlockEm
    .hidden  _ZN2nn3svc7aarch645ilp328profiler15ArbitrateUnlockEm
    .type    _ZN2nn3svc7aarch645ilp328profiler15ArbitrateUnlockEm, %function
_ZN2nn3svc7aarch645ilp328profiler15ArbitrateUnlockEm:

    svc      #NN_SVC_ID_ARBITRATE_UNLOCK
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler15ArbitrateUnlockEm, [.-_ZN2nn3svc7aarch645ilp328profiler15ArbitrateUnlockEm]


//-------------------------------------------------
// Result WaitProcessWideKeyAtomic(uintptr_t addr, uintptr_t cvKey, nn::Bit32 ownValue, int64_t ns)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 addr       Register 0       8 addr
//     Register 1       4 cvKey      Register 1       8 cvKey
//     Register 2       4 ownValue   Register 2       4 ownValue
//     Register 3       8 ns         Register 3       8 ns
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler24WaitProcessWideKeyAtomicEmmjx, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler24WaitProcessWideKeyAtomicEmmjx
    .hidden  _ZN2nn3svc7aarch645ilp328profiler24WaitProcessWideKeyAtomicEmmjx
    .type    _ZN2nn3svc7aarch645ilp328profiler24WaitProcessWideKeyAtomicEmmjx, %function
_ZN2nn3svc7aarch645ilp328profiler24WaitProcessWideKeyAtomicEmmjx:

    svc      #NN_SVC_ID_WAIT_PROCESS_WIDE_KEY_ATOMIC
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler24WaitProcessWideKeyAtomicEmmjx, [.-_ZN2nn3svc7aarch645ilp328profiler24WaitProcessWideKeyAtomicEmmjx]


//-------------------------------------------------
// void SignalProcessWideKey(uintptr_t cvKey, int32_t num)
//
//     AArch64 s=8 r=8 p=4        Invariant s=8 r=8 p=8
// in  abi                        svc
//     Register 0       4 cvKey   Register 0       8 cvKey
//     Register 1       4 num     Register 1       4 num
//
// out abi                        svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler20SignalProcessWideKeyEmi, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler20SignalProcessWideKeyEmi
    .hidden  _ZN2nn3svc7aarch645ilp328profiler20SignalProcessWideKeyEmi
    .type    _ZN2nn3svc7aarch645ilp328profiler20SignalProcessWideKeyEmi, %function
_ZN2nn3svc7aarch645ilp328profiler20SignalProcessWideKeyEmi:

    svc      #NN_SVC_ID_SIGNAL_PROCESS_WIDE_KEY
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler20SignalProcessWideKeyEmi, [.-_ZN2nn3svc7aarch645ilp328profiler20SignalProcessWideKeyEmi]


//-------------------------------------------------
// int64_t GetSystemTick()
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//
// out abi                         svc
//     Register 0       8 return   Register 0       8 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler13GetSystemTickEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler13GetSystemTickEv
    .hidden  _ZN2nn3svc7aarch645ilp328profiler13GetSystemTickEv
    .type    _ZN2nn3svc7aarch645ilp328profiler13GetSystemTickEv, %function
_ZN2nn3svc7aarch645ilp328profiler13GetSystemTickEv:

    svc      #NN_SVC_ID_GET_SYSTEM_TICK
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler13GetSystemTickEv, [.-_ZN2nn3svc7aarch645ilp328profiler13GetSystemTickEv]


//-------------------------------------------------
// Result ConnectToNamedPort(nn::svc::Handle* pOut, const char name[])
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1  ref -- name     Register 1  ref -- name
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp328profiler18ConnectToNamedPortEPNS0_6HandleEPKc, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler18ConnectToNamedPortEPNS0_6HandleEPKc
    .hidden  _ZN2nn3svc7aarch645ilp328profiler18ConnectToNamedPortEPNS0_6HandleEPKc
    .type    _ZN2nn3svc7aarch645ilp328profiler18ConnectToNamedPortEPNS0_6HandleEPKc, %function
_ZN2nn3svc7aarch645ilp328profiler18ConnectToNamedPortEPNS0_6HandleEPKc:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CONNECT_TO_NAMED_PORT

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler18ConnectToNamedPortEPNS0_6HandleEPKc, [.-_ZN2nn3svc7aarch645ilp328profiler18ConnectToNamedPortEPNS0_6HandleEPKc]


//-------------------------------------------------
// Result SendSyncRequestLight(nn::svc::Handle session)
//
//     AArch64 s=8 r=8 p=4          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0       4 session   Register 0       4 session
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler20SendSyncRequestLightENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler20SendSyncRequestLightENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler20SendSyncRequestLightENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp328profiler20SendSyncRequestLightENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp328profiler20SendSyncRequestLightENS0_6HandleE:

    svc      #NN_SVC_ID_SEND_SYNC_REQUEST_LIGHT
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler20SendSyncRequestLightENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp328profiler20SendSyncRequestLightENS0_6HandleE]


//-------------------------------------------------
// Result SendSyncRequest(nn::svc::Handle session)
//
//     AArch64 s=8 r=8 p=4          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0       4 session   Register 0       4 session
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler15SendSyncRequestENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler15SendSyncRequestENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler15SendSyncRequestENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp328profiler15SendSyncRequestENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp328profiler15SendSyncRequestENS0_6HandleE:

    svc      #NN_SVC_ID_SEND_SYNC_REQUEST
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler15SendSyncRequestENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp328profiler15SendSyncRequestENS0_6HandleE]


//-------------------------------------------------
// Result SendSyncRequestWithUserBuffer(uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0       4 pMessage     Register 0       8 pMessage
//     Register 1       4 bufferSize   Register 1       8 bufferSize
//     Register 2       4 session      Register 2       4 session
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler29SendSyncRequestWithUserBufferEmmNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler29SendSyncRequestWithUserBufferEmmNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler29SendSyncRequestWithUserBufferEmmNS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp328profiler29SendSyncRequestWithUserBufferEmmNS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp328profiler29SendSyncRequestWithUserBufferEmmNS0_6HandleE:

    svc      #NN_SVC_ID_SEND_SYNC_REQUEST_WITH_USER_BUFFER
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler29SendSyncRequestWithUserBufferEmmNS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp328profiler29SendSyncRequestWithUserBufferEmmNS0_6HandleE]


//-------------------------------------------------
// Result SendAsyncRequestWithUserBuffer(nn::svc::Handle* pEvent, uintptr_t pMessage, size_t bufferSize, nn::svc::Handle session)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0  ref  4 pEvent       
//     Register 1       4 pMessage     Register 1       8 pMessage
//     Register 2       4 bufferSize   Register 2       8 bufferSize
//     Register 3       4 session      Register 3       4 session
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//                                     Register 1       4 pEvent
//
// conversion
//   Scatter         pEvent

    .section .text._ZN2nn3svc7aarch645ilp328profiler30SendAsyncRequestWithUserBufferEPNS0_6HandleEmmS4_, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler30SendAsyncRequestWithUserBufferEPNS0_6HandleEmmS4_
    .hidden  _ZN2nn3svc7aarch645ilp328profiler30SendAsyncRequestWithUserBufferEPNS0_6HandleEmmS4_
    .type    _ZN2nn3svc7aarch645ilp328profiler30SendAsyncRequestWithUserBufferEPNS0_6HandleEmmS4_, %function
_ZN2nn3svc7aarch645ilp328profiler30SendAsyncRequestWithUserBufferEPNS0_6HandleEmmS4_:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_SEND_ASYNC_REQUEST_WITH_USER_BUFFER

    ldr      x2, [sp, #0]              // pEventのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pEvent の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler30SendAsyncRequestWithUserBufferEPNS0_6HandleEmmS4_, [.-_ZN2nn3svc7aarch645ilp328profiler30SendAsyncRequestWithUserBufferEPNS0_6HandleEmmS4_]


//-------------------------------------------------
// Result GetProcessId(nn::Bit64* pOut, nn::svc::Handle process)
//
//     AArch64 s=8 r=8 p=4          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0  ref  8 pOut      
//     Register 1       4 process   Register 1       4 process
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//                                  Register 1       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp328profiler12GetProcessIdEPyNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler12GetProcessIdEPyNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler12GetProcessIdEPyNS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp328profiler12GetProcessIdEPyNS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp328profiler12GetProcessIdEPyNS0_6HandleE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_PROCESS_ID

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler12GetProcessIdEPyNS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp328profiler12GetProcessIdEPyNS0_6HandleE]


//-------------------------------------------------
// Result GetThreadId(nn::Bit64* pOut, nn::svc::Handle thread)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  8 pOut     
//     Register 1       4 thread   Register 1       4 thread
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp328profiler11GetThreadIdEPyNS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler11GetThreadIdEPyNS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler11GetThreadIdEPyNS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp328profiler11GetThreadIdEPyNS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp328profiler11GetThreadIdEPyNS0_6HandleE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_THREAD_ID

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler11GetThreadIdEPyNS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp328profiler11GetThreadIdEPyNS0_6HandleE]


//-------------------------------------------------
// void Break(nn::svc::BreakReason reason, uintptr_t data, size_t length)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 reason   Register 0       4 reason
//     Register 1       4 data     Register 1       8 data
//     Register 2       4 length   Register 2       8 length
//
// out abi                         svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler5BreakENS0_11BreakReasonEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler5BreakENS0_11BreakReasonEmm
    .hidden  _ZN2nn3svc7aarch645ilp328profiler5BreakENS0_11BreakReasonEmm
    .type    _ZN2nn3svc7aarch645ilp328profiler5BreakENS0_11BreakReasonEmm, %function
_ZN2nn3svc7aarch645ilp328profiler5BreakENS0_11BreakReasonEmm:

    svc      #NN_SVC_ID_BREAK
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler5BreakENS0_11BreakReasonEmm, [.-_ZN2nn3svc7aarch645ilp328profiler5BreakENS0_11BreakReasonEmm]


//-------------------------------------------------
// Result OutputDebugString(const char text[], size_t length)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref -- text     Register 0  ref -- text
//     Register 1       4 length   Register 1       8 length
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler17OutputDebugStringEPKcm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler17OutputDebugStringEPKcm
    .hidden  _ZN2nn3svc7aarch645ilp328profiler17OutputDebugStringEPKcm
    .type    _ZN2nn3svc7aarch645ilp328profiler17OutputDebugStringEPKcm, %function
_ZN2nn3svc7aarch645ilp328profiler17OutputDebugStringEPKcm:

    svc      #NN_SVC_ID_OUTPUT_DEBUG_STRING
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler17OutputDebugStringEPKcm, [.-_ZN2nn3svc7aarch645ilp328profiler17OutputDebugStringEPKcm]


//-------------------------------------------------
// void ReturnFromException(nn::Result result)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 result   Register 0       4 result
//
// out abi                         svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler19ReturnFromExceptionENS_6ResultE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler19ReturnFromExceptionENS_6ResultE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler19ReturnFromExceptionENS_6ResultE
    .type    _ZN2nn3svc7aarch645ilp328profiler19ReturnFromExceptionENS_6ResultE, %function
_ZN2nn3svc7aarch645ilp328profiler19ReturnFromExceptionENS_6ResultE:

    svc      #NN_SVC_ID_RETURN_FROM_EXCEPTION
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler19ReturnFromExceptionENS_6ResultE, [.-_ZN2nn3svc7aarch645ilp328profiler19ReturnFromExceptionENS_6ResultE]


//-------------------------------------------------
// Result GetInfo(nn::Bit64* pOut, nn::svc::InfoType type, nn::svc::Handle handle, nn::Bit64 param)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  8 pOut     
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 handle   Register 2       4 handle
//     Register 3       8 param    Register 3       8 param
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       8 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp328profiler7GetInfoEPyNS0_8InfoTypeENS0_6HandleEy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler7GetInfoEPyNS0_8InfoTypeENS0_6HandleEy
    .hidden  _ZN2nn3svc7aarch645ilp328profiler7GetInfoEPyNS0_8InfoTypeENS0_6HandleEy
    .type    _ZN2nn3svc7aarch645ilp328profiler7GetInfoEPyNS0_8InfoTypeENS0_6HandleEy, %function
_ZN2nn3svc7aarch645ilp328profiler7GetInfoEPyNS0_8InfoTypeENS0_6HandleEy:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_INFO

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler7GetInfoEPyNS0_8InfoTypeENS0_6HandleEy, [.-_ZN2nn3svc7aarch645ilp328profiler7GetInfoEPyNS0_8InfoTypeENS0_6HandleEy]


//-------------------------------------------------
// void FlushEntireDataCache()
//
//     AArch64 s=8 r=8 p=4   Invariant s=8 r=8 p=8
// in  abi   svc
//
// out abi   svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler20FlushEntireDataCacheEv, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler20FlushEntireDataCacheEv
    .hidden  _ZN2nn3svc7aarch645ilp328profiler20FlushEntireDataCacheEv
    .type    _ZN2nn3svc7aarch645ilp328profiler20FlushEntireDataCacheEv, %function
_ZN2nn3svc7aarch645ilp328profiler20FlushEntireDataCacheEv:

    svc      #NN_SVC_ID_FLUSH_ENTIRE_DATA_CACHE
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler20FlushEntireDataCacheEv, [.-_ZN2nn3svc7aarch645ilp328profiler20FlushEntireDataCacheEv]


//-------------------------------------------------
// Result FlushDataCache(uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 size     Register 1       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler14FlushDataCacheEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler14FlushDataCacheEmm
    .hidden  _ZN2nn3svc7aarch645ilp328profiler14FlushDataCacheEmm
    .type    _ZN2nn3svc7aarch645ilp328profiler14FlushDataCacheEmm, %function
_ZN2nn3svc7aarch645ilp328profiler14FlushDataCacheEmm:

    svc      #NN_SVC_ID_FLUSH_DATA_CACHE
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler14FlushDataCacheEmm, [.-_ZN2nn3svc7aarch645ilp328profiler14FlushDataCacheEmm]


//-------------------------------------------------
// Result MapPhysicalMemory(uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 size     Register 1       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler17MapPhysicalMemoryEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler17MapPhysicalMemoryEmm
    .hidden  _ZN2nn3svc7aarch645ilp328profiler17MapPhysicalMemoryEmm
    .type    _ZN2nn3svc7aarch645ilp328profiler17MapPhysicalMemoryEmm, %function
_ZN2nn3svc7aarch645ilp328profiler17MapPhysicalMemoryEmm:

    svc      #NN_SVC_ID_MAP_PHYSICAL_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler17MapPhysicalMemoryEmm, [.-_ZN2nn3svc7aarch645ilp328profiler17MapPhysicalMemoryEmm]


//-------------------------------------------------
// Result UnmapPhysicalMemory(uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 size     Register 1       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler19UnmapPhysicalMemoryEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler19UnmapPhysicalMemoryEmm
    .hidden  _ZN2nn3svc7aarch645ilp328profiler19UnmapPhysicalMemoryEmm
    .type    _ZN2nn3svc7aarch645ilp328profiler19UnmapPhysicalMemoryEmm, %function
_ZN2nn3svc7aarch645ilp328profiler19UnmapPhysicalMemoryEmm:

    svc      #NN_SVC_ID_UNMAP_PHYSICAL_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler19UnmapPhysicalMemoryEmm, [.-_ZN2nn3svc7aarch645ilp328profiler19UnmapPhysicalMemoryEmm]


//-------------------------------------------------
// Result GetLastThreadInfo(nn::svc::lp64::LastThreadContext* pContext, uintptr_t* pTlsAddr, nn::Bit32* pFlag)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0  ref 32 pContext   
//     Register 1  ref  4 pTlsAddr   
//     Register 2  ref  4 pFlag      
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//                                   Register 1      32 pContext
//                                   Register 2      32 pContext
//                                   Register 3      32 pContext
//                                   Register 4      32 pContext
//                                   Register 5       8 pTlsAddr
//                                   Register 6       4 pFlag
//
// conversion
//   Scatter         pContext
//   Scatter         pTlsAddr
//   Scatter         pFlag

    .section .text._ZN2nn3svc7aarch645ilp328profiler17GetLastThreadInfoEPNS0_4lp6417LastThreadContextEPmPj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler17GetLastThreadInfoEPNS0_4lp6417LastThreadContextEPmPj
    .hidden  _ZN2nn3svc7aarch645ilp328profiler17GetLastThreadInfoEPNS0_4lp6417LastThreadContextEPmPj
    .type    _ZN2nn3svc7aarch645ilp328profiler17GetLastThreadInfoEPNS0_4lp6417LastThreadContextEPmPj, %function
_ZN2nn3svc7aarch645ilp328profiler17GetLastThreadInfoEPNS0_4lp6417LastThreadContextEPmPj:

    str      x2, [sp, #-16]!
    stp      x0, x1, [sp, #-16]!

    svc      #NN_SVC_ID_GET_LAST_THREAD_INFO

    ldr      x7, [sp, #0]              // pContextのアドレス をスタックからレジスタへ
    str      x1, [x7, #0]              // pContext の第 1 ワードをレジスタからメモリへ
    str      x2, [x7, #8]              // pContext の第 2 ワードをレジスタからメモリへ
    str      x3, [x7, #16]             // pContext の第 3 ワードをレジスタからメモリへ
    str      x4, [x7, #24]             // pContext の第 4 ワードをレジスタからメモリへ
    ldr      x7, [sp, #8]              // pTlsAddrのアドレス をスタックからレジスタへ
    str      w5, [x7, #0]              // pTlsAddr の第 1 ワードをレジスタからメモリへ
    ldr      x7, [sp, #16]             // pFlagのアドレス をスタックからレジスタへ
    str      w6, [x7, #0]              // pFlag の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #32
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler17GetLastThreadInfoEPNS0_4lp6417LastThreadContextEPmPj, [.-_ZN2nn3svc7aarch645ilp328profiler17GetLastThreadInfoEPNS0_4lp6417LastThreadContextEPmPj]


//-------------------------------------------------
// Result GetResourceLimitLimitValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource)
//
//     AArch64 s=8 r=8 p=4                Invariant s=8 r=8 p=8
// in  abi                                svc
//     Register 0  ref  8 value           
//     Register 1       4 resourceLimit   Register 1       4 resourceLimit
//     Register 2       4 resource        Register 2       4 resource
//
// out abi                                svc
//     Register 0       4 return          Register 0       4 return
//                                        Register 1       8 value
//
// conversion
//   Scatter         value

    .section .text._ZN2nn3svc7aarch645ilp328profiler26GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler26GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler26GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE
    .type    _ZN2nn3svc7aarch645ilp328profiler26GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE, %function
_ZN2nn3svc7aarch645ilp328profiler26GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_RESOURCE_LIMIT_LIMIT_VALUE

    ldr      x2, [sp, #0]              // valueのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // value の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler26GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE, [.-_ZN2nn3svc7aarch645ilp328profiler26GetResourceLimitLimitValueEPxNS0_6HandleENS0_17LimitableResourceE]


//-------------------------------------------------
// Result GetResourceLimitCurrentValue(int64_t* value, nn::svc::Handle resourceLimit, nn::svc::LimitableResource resource)
//
//     AArch64 s=8 r=8 p=4                Invariant s=8 r=8 p=8
// in  abi                                svc
//     Register 0  ref  8 value           
//     Register 1       4 resourceLimit   Register 1       4 resourceLimit
//     Register 2       4 resource        Register 2       4 resource
//
// out abi                                svc
//     Register 0       4 return          Register 0       4 return
//                                        Register 1       8 value
//
// conversion
//   Scatter         value

    .section .text._ZN2nn3svc7aarch645ilp328profiler28GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler28GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler28GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE
    .type    _ZN2nn3svc7aarch645ilp328profiler28GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE, %function
_ZN2nn3svc7aarch645ilp328profiler28GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_GET_RESOURCE_LIMIT_CURRENT_VALUE

    ldr      x2, [sp, #0]              // valueのアドレス をスタックからレジスタへ
    str      x1, [x2, #0]              // value の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler28GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE, [.-_ZN2nn3svc7aarch645ilp328profiler28GetResourceLimitCurrentValueEPxNS0_6HandleENS0_17LimitableResourceE]


//-------------------------------------------------
// Result SetThreadActivity(nn::svc::Handle handle, nn::svc::ThreadActivity activity)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 handle     Register 0       4 handle
//     Register 1       4 activity   Register 1       4 activity
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler17SetThreadActivityENS0_6HandleENS0_14ThreadActivityE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler17SetThreadActivityENS0_6HandleENS0_14ThreadActivityE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler17SetThreadActivityENS0_6HandleENS0_14ThreadActivityE
    .type    _ZN2nn3svc7aarch645ilp328profiler17SetThreadActivityENS0_6HandleENS0_14ThreadActivityE, %function
_ZN2nn3svc7aarch645ilp328profiler17SetThreadActivityENS0_6HandleENS0_14ThreadActivityE:

    svc      #NN_SVC_ID_SET_THREAD_ACTIVITY
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler17SetThreadActivityENS0_6HandleENS0_14ThreadActivityE, [.-_ZN2nn3svc7aarch645ilp328profiler17SetThreadActivityENS0_6HandleENS0_14ThreadActivityE]


//-------------------------------------------------
// Result GetThreadContext3(nn::svc::ThreadContext* pContext, nn::svc::Handle handle)
//
//     AArch64 s=8 r=8 p=4            Invariant s=8 r=8 p=8
// in  abi                            svc
//     Register 0  ref 332 pContext   Register 0  ref 332 pContext
//     Register 1       4 handle      Register 1       4 handle
//
// out abi                            svc
//     Register 0       4 return      Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler17GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler17GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler17GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE
    .type    _ZN2nn3svc7aarch645ilp328profiler17GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE, %function
_ZN2nn3svc7aarch645ilp328profiler17GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE:

    svc      #NN_SVC_ID_GET_THREAD_CONTEXT3
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler17GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE, [.-_ZN2nn3svc7aarch645ilp328profiler17GetThreadContext3EPNS0_13ThreadContextENS0_6HandleE]


//-------------------------------------------------
// Result WaitForAddress(uintptr_t addr, nn::svc::ArbitrationType type, int32_t value, int64_t ns)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 value    Register 2       4 value
//     Register 3       8 ns       Register 3       8 ns
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler14WaitForAddressEmNS0_15ArbitrationTypeEix, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler14WaitForAddressEmNS0_15ArbitrationTypeEix
    .hidden  _ZN2nn3svc7aarch645ilp328profiler14WaitForAddressEmNS0_15ArbitrationTypeEix
    .type    _ZN2nn3svc7aarch645ilp328profiler14WaitForAddressEmNS0_15ArbitrationTypeEix, %function
_ZN2nn3svc7aarch645ilp328profiler14WaitForAddressEmNS0_15ArbitrationTypeEix:

    svc      #NN_SVC_ID_WAIT_FOR_ADDRESS
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler14WaitForAddressEmNS0_15ArbitrationTypeEix, [.-_ZN2nn3svc7aarch645ilp328profiler14WaitForAddressEmNS0_15ArbitrationTypeEix]


//-------------------------------------------------
// Result SignalToAddress(uintptr_t addr, nn::svc::SignalType type, int32_t value, int32_t num)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 addr     Register 0       8 addr
//     Register 1       4 type     Register 1       4 type
//     Register 2       4 value    Register 2       4 value
//     Register 3       4 num      Register 3       4 num
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler15SignalToAddressEmNS0_10SignalTypeEii, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler15SignalToAddressEmNS0_10SignalTypeEii
    .hidden  _ZN2nn3svc7aarch645ilp328profiler15SignalToAddressEmNS0_10SignalTypeEii
    .type    _ZN2nn3svc7aarch645ilp328profiler15SignalToAddressEmNS0_10SignalTypeEii, %function
_ZN2nn3svc7aarch645ilp328profiler15SignalToAddressEmNS0_10SignalTypeEii:

    svc      #NN_SVC_ID_SIGNAL_TO_ADDRESS
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler15SignalToAddressEmNS0_10SignalTypeEii, [.-_ZN2nn3svc7aarch645ilp328profiler15SignalToAddressEmNS0_10SignalTypeEii]


//-------------------------------------------------
// void KernelDebug(nn::svc::KernelDebugType type, nn::Bit64 param0, nn::Bit64 param1, nn::Bit64 param2)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0       4 type     Register 0       4 type
//     Register 1       8 param0   Register 1       8 param0
//     Register 2       8 param1   Register 2       8 param1
//     Register 3       8 param2   Register 3       8 param2
//
// out abi                         svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler11KernelDebugENS0_15KernelDebugTypeEyyy, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler11KernelDebugENS0_15KernelDebugTypeEyyy
    .hidden  _ZN2nn3svc7aarch645ilp328profiler11KernelDebugENS0_15KernelDebugTypeEyyy
    .type    _ZN2nn3svc7aarch645ilp328profiler11KernelDebugENS0_15KernelDebugTypeEyyy, %function
_ZN2nn3svc7aarch645ilp328profiler11KernelDebugENS0_15KernelDebugTypeEyyy:

    svc      #NN_SVC_ID_KERNEL_DEBUG
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler11KernelDebugENS0_15KernelDebugTypeEyyy, [.-_ZN2nn3svc7aarch645ilp328profiler11KernelDebugENS0_15KernelDebugTypeEyyy]


//-------------------------------------------------
// void ChangeKernelTraceState(nn::svc::KernelTraceState state)
//
//     AArch64 s=8 r=8 p=4        Invariant s=8 r=8 p=8
// in  abi                        svc
//     Register 0       4 state   Register 0       4 state
//
// out abi                        svc
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler22ChangeKernelTraceStateENS0_16KernelTraceStateE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler22ChangeKernelTraceStateENS0_16KernelTraceStateE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler22ChangeKernelTraceStateENS0_16KernelTraceStateE
    .type    _ZN2nn3svc7aarch645ilp328profiler22ChangeKernelTraceStateENS0_16KernelTraceStateE, %function
_ZN2nn3svc7aarch645ilp328profiler22ChangeKernelTraceStateENS0_16KernelTraceStateE:

    svc      #NN_SVC_ID_CHANGE_KERNEL_TRACE_STATE
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler22ChangeKernelTraceStateENS0_16KernelTraceStateE, [.-_ZN2nn3svc7aarch645ilp328profiler22ChangeKernelTraceStateENS0_16KernelTraceStateE]


//-------------------------------------------------
// Result CreateCodeMemory(nn::svc::Handle* pOut, uintptr_t addr, size_t size)
//
//     AArch64 s=8 r=8 p=4         Invariant s=8 r=8 p=8
// in  abi                         svc
//     Register 0  ref  4 pOut     
//     Register 1       4 addr     Register 1       8 addr
//     Register 2       4 size     Register 2       8 size
//
// out abi                         svc
//     Register 0       4 return   Register 0       4 return
//                                 Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp328profiler16CreateCodeMemoryEPNS0_6HandleEmm, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler16CreateCodeMemoryEPNS0_6HandleEmm
    .hidden  _ZN2nn3svc7aarch645ilp328profiler16CreateCodeMemoryEPNS0_6HandleEmm
    .type    _ZN2nn3svc7aarch645ilp328profiler16CreateCodeMemoryEPNS0_6HandleEmm, %function
_ZN2nn3svc7aarch645ilp328profiler16CreateCodeMemoryEPNS0_6HandleEmm:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_CREATE_CODE_MEMORY

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler16CreateCodeMemoryEPNS0_6HandleEmm, [.-_ZN2nn3svc7aarch645ilp328profiler16CreateCodeMemoryEPNS0_6HandleEmm]


//-------------------------------------------------
// Result ControlCodeMemory(nn::svc::Handle handle, nn::svc::CodeMemoryOperation operation, uint64_t address, uint64_t size, nn::svc::MemoryPermission permission)
//
//     AArch64 s=8 r=8 p=4             Invariant s=8 r=8 p=8
// in  abi                             svc
//     Register 0       4 handle       Register 0       4 handle
//     Register 1       4 operation    Register 1       4 operation
//     Register 2       8 address      Register 2       8 address
//     Register 3       8 size         Register 3       8 size
//     Register 4       4 permission   Register 4       4 permission
//
// out abi                             svc
//     Register 0       4 return       Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler17ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler17ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler17ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE
    .type    _ZN2nn3svc7aarch645ilp328profiler17ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE, %function
_ZN2nn3svc7aarch645ilp328profiler17ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE:

    svc      #NN_SVC_ID_CONTROL_CODE_MEMORY
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler17ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE, [.-_ZN2nn3svc7aarch645ilp328profiler17ControlCodeMemoryENS0_6HandleENS0_19CodeMemoryOperationEyyNS0_16MemoryPermissionE]


//-------------------------------------------------
// Result ReadWriteRegister(nn::Bit32* pOut, nn::svc::PhysicalAddress address, nn::Bit32 mask, nn::Bit32 value)
//
//     AArch64 s=8 r=8 p=4          Invariant s=8 r=8 p=8
// in  abi                          svc
//     Register 0  ref  4 pOut      
//     Register 1       8 address   Register 1       8 address
//     Register 2       4 mask      Register 2       4 mask
//     Register 3       4 value     Register 3       4 value
//
// out abi                          svc
//     Register 0       4 return    Register 0       4 return
//                                  Register 1       4 pOut
//
// conversion
//   Scatter         pOut

    .section .text._ZN2nn3svc7aarch645ilp328profiler17ReadWriteRegisterEPjyjj, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler17ReadWriteRegisterEPjyjj
    .hidden  _ZN2nn3svc7aarch645ilp328profiler17ReadWriteRegisterEPjyjj
    .type    _ZN2nn3svc7aarch645ilp328profiler17ReadWriteRegisterEPjyjj, %function
_ZN2nn3svc7aarch645ilp328profiler17ReadWriteRegisterEPjyjj:

    str      x0, [sp, #-16]!

    svc      #NN_SVC_ID_READ_WRITE_REGISTER

    ldr      x2, [sp, #0]              // pOutのアドレス をスタックからレジスタへ
    str      w1, [x2, #0]              // pOut の第 1 ワードをレジスタからメモリへ

    add      sp, sp, #16
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler17ReadWriteRegisterEPjyjj, [.-_ZN2nn3svc7aarch645ilp328profiler17ReadWriteRegisterEPjyjj]


//-------------------------------------------------
// Result SetProcessActivity(nn::svc::Handle handle, nn::svc::ProcessActivity activity)
//
//     AArch64 s=8 r=8 p=4           Invariant s=8 r=8 p=8
// in  abi                           svc
//     Register 0       4 handle     Register 0       4 handle
//     Register 1       4 activity   Register 1       4 activity
//
// out abi                           svc
//     Register 0       4 return     Register 0       4 return
//
// conversion

    .section .text._ZN2nn3svc7aarch645ilp328profiler18SetProcessActivityENS0_6HandleENS0_15ProcessActivityE, "ax"
    .align   2
    .global  _ZN2nn3svc7aarch645ilp328profiler18SetProcessActivityENS0_6HandleENS0_15ProcessActivityE
    .hidden  _ZN2nn3svc7aarch645ilp328profiler18SetProcessActivityENS0_6HandleENS0_15ProcessActivityE
    .type    _ZN2nn3svc7aarch645ilp328profiler18SetProcessActivityENS0_6HandleENS0_15ProcessActivityE, %function
_ZN2nn3svc7aarch645ilp328profiler18SetProcessActivityENS0_6HandleENS0_15ProcessActivityE:

    svc      #NN_SVC_ID_SET_PROCESS_ACTIVITY
    ret

    .size _ZN2nn3svc7aarch645ilp328profiler18SetProcessActivityENS0_6HandleENS0_15ProcessActivityE, [.-_ZN2nn3svc7aarch645ilp328profiler18SetProcessActivityENS0_6HandleENS0_15ProcessActivityE]


    .end

